/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.documentr.generator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import nl.jworks.markdown_to_asciidoc.Converter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.json.JSONArray;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.RootNode;
import synapticloop.documentr.bean.ConfigurationBean;
import synapticloop.documentr.bean.StartEndBean;
import synapticloop.documentr.exception.DocumentrException;
import synapticloop.documentr.plugin.DocumentrPluginExtension;
import synapticloop.templar.Parser;
import synapticloop.templar.exception.ParseException;
import synapticloop.templar.exception.RenderException;
import synapticloop.templar.utils.TemplarContext;

public class Generator {
    private static final String DOCUMENTR_DELIMETER = "\u00a7\u00a7";
    private static final String DOCUMENTR_TABLE_OF_CONTENTS = "\u00a7\u00a7DOCUMENTR_TABLE_OF_CONTENTS\u00a7\u00a7";
    private static final String DOCUMENTR_CODE_FENCE_PREFIX = "\u00a7\u00a7DOCUMENTR_CODE_FENCE_";
    private static final String EXTENSIONE_ADOC = "adoc";
    private static final String KEY_VALUE = "value";
    private static final String KEY_TYPE = "type";
    private static final int TYPE_FILE = 1;
    private static final int TYPE_INBUILT = 0;
    private static final int TYPE_TEMPLAR = 2;
    private static final int TYPE_TEMPLATE = 3;
    private static final int TYPE_MARKUP = 4;
    private static final int TYPE_MARKDOWN = 5;
    private static final int TYPE_TOC = 6;
    private static final int TYPE_TOCBACKTOTOP = 7;
    private static final int TYPE_TOCLINKS = 8;
    private static final String CONTEXT_CONFIGURATION_BEANS = "configurationBeans";
    private static final String CONTEXT_CONFIGURATIONS = "configurations";
    private static final Map<StartEndBean, Integer> HEADER_LOOKUP = new LinkedHashMap<StartEndBean, Integer>();
    private static final Map<Integer, String> SPACING_LOOKUP = new HashMap<Integer, String>();
    private static final Map<String, Integer> TYPE_LOOKUP = new HashMap<String, Integer>();
    private String documentrFile;
    private final File rootDirectory;
    private final String fileExtension;
    private boolean verbose = false;
    private int tocLevel = 6;
    private boolean hasToc = false;
    private boolean hasTocBackToTop = false;
    private String tocBackToTop = " <sup><sup>[top](#)</sup></sup>";
    private boolean hasTocLinks = false;
    private final TemplarContext templarContext = new TemplarContext();
    private List<ConfigurationBean> configurationBeans = new ArrayList<ConfigurationBean>();
    private Map<Integer, StringBuilder> codeFenceBlocks = new ConcurrentHashMap<Integer, StringBuilder>();

    public Generator(Project project, DocumentrPluginExtension extension) {
        InputStream resourceAsStream;
        this.documentrFile = extension.getDocumentrFile();
        this.rootDirectory = new File(extension.getDirectory());
        this.verbose = extension.getVerbose();
        this.fileExtension = extension.getExtension();
        ConfigurationContainer configurations = project.getConfigurations();
        SortedSet configurationNames = configurations.getNames();
        for (String configurationName : configurationNames) {
            ConfigurationBean configurationBean = new ConfigurationBean(configurationName);
            Configuration configuration = configurations.getByName(configurationName);
            DependencySet dependencySet = configuration.getDependencies();
            configurationBean.addDependencies(dependencySet);
            this.configurationBeans.add(configurationBean);
        }
        this.templarContext.add(CONTEXT_CONFIGURATIONS, (Object)project.getConfigurations());
        this.templarContext.add(CONTEXT_CONFIGURATION_BEANS, this.configurationBeans);
        for (String key : project.getProperties().keySet()) {
            this.templarContext.add(key, project.getProperties().get(key));
        }
        File rootDirectory = new File(extension.getDirectory());
        File documentrJsonFile = new File(rootDirectory.getAbsolutePath() + "/" + "documentr.json");
        if (!documentrJsonFile.exists() && "documentr.json".equals(this.documentrFile) && null != (resourceAsStream = Generator.class.getResourceAsStream("/documentr-default.json"))) {
            try {
                FileUtils.write((File)documentrJsonFile, (CharSequence)IOUtils.toString((InputStream)resourceAsStream));
                project.getLogger().info(String.format("We couldn't find a the default '%s' file, so we created it for you", "documentr.json"));
            }
            catch (IOException ex) {
                project.getLogger().error(String.format("Could not create the default documentr.json file, message was '%s'", ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public Generator(File rootDirectory, String extension, boolean debug) {
        this.fileExtension = extension;
        this.rootDirectory = rootDirectory;
        this.verbose = debug;
    }

    public void generate() throws DocumentrException {
        File documentrJsonFile = new File(this.rootDirectory.getAbsolutePath() + "/" + this.documentrFile);
        if (documentrJsonFile.exists() && documentrJsonFile.canRead()) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                JSONObject jsonObject = new JSONObject(FileUtils.readFileToString((File)documentrJsonFile));
                JSONArray jsonArray = jsonObject.getJSONArray("templates");
                block14: for (Object object : jsonArray) {
                    JSONObject templateObject = (JSONObject)object;
                    String type = templateObject.getString(KEY_TYPE);
                    if (!TYPE_LOOKUP.containsKey(type)) {
                        throw new DocumentrException(String.format("Unknown type of '%s'", type));
                    }
                    String value = templateObject.optString(KEY_VALUE, "");
                    String pathname = documentrJsonFile.getParent() + "/" + value;
                    switch (TYPE_LOOKUP.get(type)) {
                        case 1: {
                            stringBuilder.append("{pre\n");
                            stringBuilder.append(FileUtils.readFileToString((File)new File(pathname)));
                            stringBuilder.append("\npre}\n");
                            break;
                        }
                        case 4: 
                        case 5: {
                            stringBuilder.append("\n");
                            stringBuilder.append(value.replaceAll("\\{", "\\{\\{").replaceAll("\\n", "\\{\\\\n\\}").replaceAll("\\t", "\\{\\\\t\\}"));
                            stringBuilder.append("\n");
                            break;
                        }
                        case 3: {
                            stringBuilder.append("\n");
                            stringBuilder.append("{import ");
                            stringBuilder.append(pathname);
                            stringBuilder.append("}\n");
                            stringBuilder.append("\n");
                            break;
                        }
                        case 2: {
                            stringBuilder.append(value);
                            break;
                        }
                        case 0: {
                            stringBuilder.append("{import classpath:/");
                            stringBuilder.append(this.getInbuiltTemplateName(value));
                            stringBuilder.append("}\n");
                            break;
                        }
                        case 6: {
                            this.hasToc = true;
                            stringBuilder.append("\n\n\u00a7\u00a7DOCUMENTR_TABLE_OF_CONTENTS\u00a7\u00a7\n\n");
                            try {
                                this.tocLevel = Integer.parseInt(value);
                                if (this.tocLevel > 6) {
                                    this.tocLevel = 6;
                                }
                                if (this.tocLevel > 0) continue block14;
                                this.tocLevel = 1;
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case 7: {
                            this.hasTocBackToTop = true;
                            if (value.equalsIgnoreCase("")) continue block14;
                            this.tocBackToTop = value;
                            break;
                        }
                        case 8: {
                            if (!value.equalsIgnoreCase("true")) continue block14;
                            this.hasTocLinks = true;
                            break;
                        }
                        default: {
                            throw new DocumentrException(String.format("Could not determine type %s", type));
                        }
                    }
                }
                this.templarContext.add("yearTo", (Object)Calendar.getInstance().get(1));
                this.overrideContext(this.templarContext, jsonObject);
                if (this.verbose) {
                    System.out.println(stringBuilder.toString());
                }
                Parser parser = new Parser(stringBuilder.toString());
                String rendered = parser.render(this.templarContext);
                File outputFile = new File(documentrJsonFile.getParent() + "/README." + this.fileExtension);
                if (this.hasToc) {
                    rendered = this.renderTableOfContents(rendered);
                }
                if (EXTENSIONE_ADOC.equals(this.fileExtension)) {
                    FileUtils.writeStringToFile((File)outputFile, (String)Converter.convertMarkdownToAsciiDoc((String)rendered));
                }
                FileUtils.writeStringToFile((File)outputFile, (String)rendered);
            }
            catch (IOException | ParseException | RenderException ex) {
                throw new DocumentrException(String.format("Cannot parse/render the '%s' file, message was: %s", documentrJsonFile, ex.getMessage()), ex);
            }
        } else {
            throw new DocumentrException(String.format("Cannot find the '%s' file.", documentrJsonFile));
        }
    }

    private String renderTableOfContents(String rendered) {
        String renderedClean = this.removeCodeFenceBlocks(rendered);
        int numHeader = 0;
        StringBuilder headerStringBuilder = new StringBuilder("\n\n");
        PegDownProcessor pegDownProcessor = new PegDownProcessor();
        String markdownToHtml = pegDownProcessor.markdownToHtml(renderedClean);
        numHeader = 0;
        Document document = Jsoup.parse((String)markdownToHtml);
        Elements headings = document.select("h1, h2, h3, h4, h5, h6");
        for (Element heading : headings) {
            int valueOf = Integer.parseInt(heading.nodeName().substring(1));
            if (valueOf <= this.tocLevel) {
                if (this.hasTocLinks) {
                    headerStringBuilder.append(SPACING_LOOKUP.get(valueOf) + "[" + heading.text() + "](#heading_" + numHeader + ")\n");
                } else {
                    headerStringBuilder.append(SPACING_LOOKUP.get(valueOf) + heading.text() + "\n");
                }
            }
            ++numHeader;
        }
        headerStringBuilder.append("\n\n");
        numHeader = 0;
        char[] charArray = renderedClean.toCharArray();
        RootNode rootNode = pegDownProcessor.parseMarkdown(charArray);
        List children = rootNode.getChildren();
        for (Node node : children) {
            if (!(node instanceof HeaderNode)) continue;
            HeaderNode headerNode = (HeaderNode)node;
            int level = headerNode.getLevel();
            if (level <= this.tocLevel) {
                HEADER_LOOKUP.put(new StartEndBean(headerNode.getStartIndex(), headerNode.getEndIndex()), numHeader);
            }
            ++numHeader;
        }
        if (this.hasTocLinks) {
            Iterator<StartEndBean> iterator = HEADER_LOOKUP.keySet().iterator();
            int start = 0;
            StringBuilder renderedStringBuilder = new StringBuilder();
            while (iterator.hasNext()) {
                StartEndBean startEndBean = iterator.next();
                int headerStart = startEndBean.getStart();
                int headerEnd = startEndBean.getEnd();
                Integer headerNum = HEADER_LOOKUP.get(startEndBean);
                renderedStringBuilder.append(Arrays.copyOfRange(charArray, start, headerStart));
                renderedStringBuilder.append("\n\n<a name=\"heading_" + headerNum + "\"></a>\n\n");
                if (this.hasTocBackToTop) {
                    renderedStringBuilder.append(Arrays.copyOfRange(charArray, headerStart, headerEnd - 1));
                    renderedStringBuilder.append(this.tocBackToTop);
                    start = headerEnd - 1;
                    continue;
                }
                start = headerStart;
            }
            renderedStringBuilder.append(Arrays.copyOfRange(charArray, start, charArray.length));
            renderedClean = renderedStringBuilder.toString();
        }
        renderedClean = renderedClean.replace(DOCUMENTR_TABLE_OF_CONTENTS, headerStringBuilder.toString());
        for (Integer integer : this.codeFenceBlocks.keySet()) {
            renderedClean = renderedClean.replaceAll(String.format("%s%d%s", DOCUMENTR_CODE_FENCE_PREFIX, integer, DOCUMENTR_DELIMETER), this.codeFenceBlocks.get(integer).toString());
        }
        return renderedClean;
    }

    private String removeCodeFenceBlocks(String rendered) {
        String[] lines;
        StringBuilder stringBuilder = new StringBuilder();
        boolean isInCodeFence = false;
        int codeFenceNumber = 0;
        for (String line : lines = rendered.split("\\n")) {
            StringBuilder lineStringBuilder;
            if (line.contains("```") || line.contains("~~~")) {
                isInCodeFence = !isInCodeFence;
                lineStringBuilder = this.codeFenceBlocks.get(codeFenceNumber);
                if (null == lineStringBuilder) {
                    lineStringBuilder = new StringBuilder();
                }
                lineStringBuilder.append(line);
                lineStringBuilder.append("\n");
                this.codeFenceBlocks.put(codeFenceNumber, lineStringBuilder);
                if (isInCodeFence) continue;
                stringBuilder.append("\n\n\u00a7\u00a7DOCUMENTR_CODE_FENCE_" + codeFenceNumber + DOCUMENTR_DELIMETER + "\n\n");
                ++codeFenceNumber;
                continue;
            }
            if (!isInCodeFence) {
                stringBuilder.append(line);
                stringBuilder.append("\n");
                continue;
            }
            lineStringBuilder = this.codeFenceBlocks.get(codeFenceNumber);
            if (null == lineStringBuilder) {
                lineStringBuilder = new StringBuilder();
            }
            lineStringBuilder.append(line);
            lineStringBuilder.append("\n");
            this.codeFenceBlocks.put(codeFenceNumber, lineStringBuilder);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInbuiltTemplateName(String template) {
        InputStream resourceAsStream = null;
        try {
            String lookForTemplate = String.format("%s.%s.templar", template, this.fileExtension);
            resourceAsStream = Generator.class.getResourceAsStream("/" + lookForTemplate);
            if (null == resourceAsStream) {
                String string = String.format("%s.md.templar", template);
                return string;
            }
            String string = lookForTemplate;
            return string;
        }
        finally {
            if (null != resourceAsStream) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void overrideContext(TemplarContext templarContext, JSONObject jsonObject) {
        JSONObject contextObject = jsonObject.getJSONObject("context");
        if (null != contextObject) {
            Iterator keys = contextObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                templarContext.add(key, contextObject.get(key));
            }
        }
    }

    static {
        TYPE_LOOKUP.put("inbuilt", 0);
        TYPE_LOOKUP.put("file", 1);
        TYPE_LOOKUP.put("templar", 2);
        TYPE_LOOKUP.put("template", 3);
        TYPE_LOOKUP.put("markup", 4);
        TYPE_LOOKUP.put("markdown", 5);
        TYPE_LOOKUP.put("toc", 6);
        TYPE_LOOKUP.put("toclinks", 8);
        TYPE_LOOKUP.put("tocbacktotop", 7);
        SPACING_LOOKUP.put(1, " - ");
        SPACING_LOOKUP.put(2, "   - ");
        SPACING_LOOKUP.put(3, "     - ");
        SPACING_LOOKUP.put(4, "       - ");
        SPACING_LOOKUP.put(5, "         - ");
        SPACING_LOOKUP.put(6, "           - ");
    }
}

