/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.documentr.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.json.JSONArray;
import org.json.JSONObject;
import synapticloop.documentr.bean.ConfigurationBean;
import synapticloop.documentr.exception.DocumentrException;
import synapticloop.templar.Parser;
import synapticloop.templar.exception.ParseException;
import synapticloop.templar.exception.RenderException;
import synapticloop.templar.utils.TemplarContext;

public class Generator {
    private static final String VALUE = "value";
    private static final String TYPE = "type";
    private static final int TYPE_FILE = 1;
    private static final int TYPE_INBUILT = 0;
    private static final int TYPE_TEMPLAR = 2;
    private static final int TYPE_TEMPLATE = 3;
    private static final int TYPE_MARKUP = 4;
    private static final Map<String, Integer> TYPE_LOOKUP = new HashMap<String, Integer>();
    private Project project;
    private final File rootDirectory;
    private final TemplarContext templarContext = new TemplarContext();
    private List<ConfigurationBean> configurationBeans = new ArrayList<ConfigurationBean>();
    private boolean verbose = false;

    public Generator(Project project, File rootDirectory, boolean verbose) {
        this.project = project;
        this.rootDirectory = rootDirectory;
        this.verbose = verbose;
        ConfigurationContainer configurations = project.getConfigurations();
        SortedSet configurationNames = configurations.getNames();
        for (String configurationName : configurationNames) {
            ConfigurationBean configurationBean = new ConfigurationBean(configurationName);
            Configuration configuration = configurations.getByName(configurationName);
            DependencySet dependencySet = configuration.getDependencies();
            configurationBean.addDependency(dependencySet);
            this.configurationBeans.add(configurationBean);
        }
        this.templarContext.add("configurations", (Object)project.getConfigurations());
        this.templarContext.add("configurationBeans", this.configurationBeans);
        for (String key : project.getProperties().keySet()) {
            this.templarContext.add(key, project.getProperties().get(key));
        }
    }

    public Generator(File rootDirectory, boolean debug) {
        this.rootDirectory = rootDirectory;
        this.verbose = debug;
    }

    public void generate() throws DocumentrException {
        File documentrJsonFile = new File(this.rootDirectory.getAbsolutePath() + "/documentr.json");
        if (documentrJsonFile.exists() && documentrJsonFile.canRead()) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                JSONObject jsonObject = new JSONObject(FileUtils.readFileToString((File)documentrJsonFile));
                JSONArray jsonArray = jsonObject.getJSONArray("templates");
                block9: for (Object object : jsonArray) {
                    JSONObject templateObject = (JSONObject)object;
                    String type = templateObject.getString(TYPE);
                    if (!TYPE_LOOKUP.containsKey(type)) {
                        throw new DocumentrException(String.format("Unknown type of '%s'", type));
                    }
                    String pathname = documentrJsonFile.getParent() + "/" + templateObject.getString(VALUE);
                    switch (TYPE_LOOKUP.get(type)) {
                        case 1: {
                            stringBuilder.append("{pre\n");
                            stringBuilder.append(FileUtils.readFileToString((File)new File(pathname)));
                            stringBuilder.append("\npre}\n");
                            continue block9;
                        }
                        case 4: {
                            stringBuilder.append("\n");
                            stringBuilder.append(templateObject.getString(VALUE).replaceAll("\\{", "\\{\\{").replaceAll("\\n", "\\{\\\\n\\}").replaceAll("\\t", "\\{\\\\t\\}"));
                            stringBuilder.append("\n");
                            continue block9;
                        }
                        case 3: {
                            stringBuilder.append("\n");
                            stringBuilder.append("{import ");
                            stringBuilder.append(pathname);
                            stringBuilder.append("}\n");
                            stringBuilder.append("\n");
                            continue block9;
                        }
                        case 2: {
                            stringBuilder.append(templateObject.getString(VALUE));
                            continue block9;
                        }
                        case 0: {
                            stringBuilder.append("{import classpath:/");
                            stringBuilder.append(templateObject.getString(VALUE));
                            stringBuilder.append(".templar}\n");
                            continue block9;
                        }
                    }
                    throw new DocumentrException(String.format("Could not determine type %s", type));
                }
                this.templarContext.add("yearTo", (Object)Calendar.getInstance().get(1));
                this.overrideContext(this.templarContext, jsonObject);
                if (this.verbose) {
                    System.out.println(stringBuilder.toString());
                }
                Parser parser = new Parser(stringBuilder.toString());
                FileUtils.writeStringToFile((File)new File(documentrJsonFile.getParent() + "/README.md"), (String)parser.render(this.templarContext));
            }
            catch (IOException | ParseException | RenderException ex) {
                throw new DocumentrException("Cannot parse/render the documentr.json file, message was: " + ex.getMessage(), ex);
            }
        } else {
            throw new DocumentrException("Cannot find the documentr.json file.");
        }
    }

    private void overrideContext(TemplarContext templarContext, JSONObject jsonObject) {
        JSONObject contextObject = jsonObject.getJSONObject("context");
        Iterator keys = contextObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            templarContext.add(key, contextObject.get(key));
        }
    }

    static {
        TYPE_LOOKUP.put("inbuilt", 0);
        TYPE_LOOKUP.put("file", 1);
        TYPE_LOOKUP.put("templar", 2);
        TYPE_LOOKUP.put("template", 3);
        TYPE_LOOKUP.put("markup", 4);
    }
}

