/*
 * Decompiled with CFR 0.152.
 */
package svarzee.gps.gpsoauth;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Properties;

class GpsoauthConfig {
    private final BigInteger modulus;
    private final BigInteger exponent;

    GpsoauthConfig(String configFile) {
        Properties properties = this.getProperties();
        this.modulus = new BigInteger(properties.getProperty("modulus"));
        this.exponent = new BigInteger(properties.getProperty("exponent"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getProperties() {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("gpsoauth.properties");){
            Properties properties = new Properties();
            properties.load(stream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getExponent() {
        return this.exponent;
    }
}

