/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.sql.DatabaseMetaData;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jline.reader.impl.completer.StringsCompleter;
import sqlline.Dialect;
import sqlline.SqlLine;

class SqlCompleter
extends StringsCompleter {
    SqlCompleter(SqlLine sqlLine, boolean skipMeta) {
        super(SqlCompleter.getCompletions(sqlLine, skipMeta));
    }

    private static Iterable<String> getCompletions(SqlLine sqlLine, boolean skipMeta) {
        TreeSet<String> completions = new TreeSet<String>();
        StringBuilder keywords = new StringBuilder();
        DatabaseMetaData meta = sqlLine.getDatabaseConnection().meta;
        try {
            keywords.append(",").append(meta.getSQLKeywords());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            keywords.append(",").append(meta.getStringFunctions());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            keywords.append(",").append(meta.getNumericFunctions());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            keywords.append(",").append(meta.getSystemFunctions());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            keywords.append(",").append(meta.getTimeDateFunctions());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        StringTokenizer tok = new StringTokenizer(keywords.toString(), ", ");
        while (tok.hasMoreTokens()) {
            completions.add(tok.nextToken());
        }
        if (!skipMeta) {
            completions.addAll(sqlLine.getColumnNames(meta));
        }
        completions.addAll(Dialect.DEFAULT_KEYWORD_SET);
        return completions;
    }
}

