/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import sqlline.BuiltInDialect;
import sqlline.Dialect;

class DialectImpl
implements Dialect {
    private static final DialectImpl DEFAULT = DialectImpl.create(null, null, null);
    private final Set<String> keywords;
    private final Set<String> oneLineComments;
    private final char openQuote;
    private final char closeQuote;
    private final boolean storesUpperCaseIdentifier;

    static DialectImpl create(Set<String> keywords, String identifierQuote, String productName) {
        return DialectImpl.create(keywords, identifierQuote, productName, true);
    }

    static DialectImpl create(Set<String> keywords, String identifierQuote, String productName, boolean storesUpperCaseIdentifier) {
        char closeQuote;
        char openQuote;
        Set<String> keywords2 = keywords == null ? Collections.emptySet() : Collections.unmodifiableSet(keywords);
        BuiltInDialect dialect = BuiltInDialect.valueOf(productName, true);
        if (identifierQuote == null) {
            openQuote = dialect.getOpenQuote();
            closeQuote = dialect.getCloseQuote();
        } else {
            openQuote = identifierQuote.charAt(0);
            switch (openQuote) {
                case '[': {
                    closeQuote = ']';
                    break;
                }
                default: {
                    closeQuote = openQuote;
                }
            }
        }
        return new DialectImpl(keywords2, storesUpperCaseIdentifier, dialect.getOneLineComments(), openQuote, closeQuote);
    }

    private DialectImpl(Set<String> keywords, boolean storesUpperCaseIdentifier, Set<String> oneLineComments, char openQuote, char closeQuote) {
        this.keywords = Objects.requireNonNull(keywords);
        this.storesUpperCaseIdentifier = storesUpperCaseIdentifier;
        this.oneLineComments = oneLineComments;
        this.openQuote = openQuote;
        this.closeQuote = closeQuote;
    }

    public static Dialect getDefault() {
        return DEFAULT;
    }

    @Override
    public boolean containsKeyword(String keyword) {
        return this.keywords.contains(keyword) || DEFAULT_KEYWORD_SET.contains(keyword);
    }

    @Override
    public Set<String> getOneLineComments() {
        return this.oneLineComments;
    }

    @Override
    public char getOpenQuote() {
        return this.openQuote;
    }

    @Override
    public char getCloseQuote() {
        return this.closeQuote;
    }

    @Override
    public boolean isUpper() {
        return this.storesUpperCaseIdentifier;
    }
}

