/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class DatabaseMetaDataHandler
implements InvocationHandler {
    private final DatabaseMetaData metaData;

    DatabaseMetaDataHandler(DatabaseMetaData metaData) {
        this.metaData = Objects.requireNonNull(metaData);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this.metaData, args);
        }
        catch (Throwable e) {
            MethodWithDefault methodWithDefault = MethodWithDefault.lookup(method);
            if (methodWithDefault != null) {
                return methodWithDefault.defaultValue;
            }
            throw e;
        }
    }

    private static enum MethodWithDefault {
        allProceduresAreCallable(false, new Class[0]),
        allTablesAreSelectable(false, new Class[0]),
        autoCommitFailureClosesAllResultSets(false, new Class[0]),
        dataDefinitionCausesTransactionCommit(false, new Class[0]),
        deletesAreDetected(false, Integer.TYPE),
        dataDefinitionIgnoredInTransactions(false, new Class[0]),
        doesMaxRowSizeIncludeBlobs(false, new Class[0]),
        generatedKeyAlwaysReturned(false, new Class[0]),
        getDatabaseProductName(null, new Class[0]),
        getIdentifierQuoteString(" ", new Class[0]),
        getMaxBinaryLiteralLength(0, new Class[0]),
        getMaxCatalogNameLength(0, new Class[0]),
        getMaxCharLiteralLength(0, new Class[0]),
        getMaxColumnNameLength(0, new Class[0]),
        getMaxColumnsInGroupBy(0, new Class[0]),
        getMaxColumnsInIndex(0, new Class[0]),
        getMaxColumnsInOrderBy(0, new Class[0]),
        getMaxColumnsInSelect(0, new Class[0]),
        getMaxColumnsInTable(0, new Class[0]),
        getMaxConnections(0, new Class[0]),
        getMaxCursorNameLength(0, new Class[0]),
        getMaxLogicalLobSize(0, new Class[0]),
        getMaxIndexLength(0, new Class[0]),
        getMaxProcedureNameLength(0, new Class[0]),
        getMaxRowSize(0, new Class[0]),
        getMaxSchemaNameLength(0, new Class[0]),
        getMaxStatementLength(0, new Class[0]),
        getMaxStatements(0, new Class[0]),
        getMaxTableNameLength(0, new Class[0]),
        getMaxTablesInSelect(0, new Class[0]),
        getMaxUserNameLength(0, new Class[0]),
        getNumericFunctions("", new Class[0]),
        getStringFunctions("", new Class[0]),
        getSQLKeywords("", new Class[0]),
        getSystemFunctions("", new Class[0]),
        getTimeDateFunctions("", new Class[0]),
        getURL(null, new Class[0]),
        insertsAreDetected(false, Integer.TYPE),
        isCatalogAtStart(false, new Class[0]),
        isReadOnly(false, new Class[0]),
        nullPlusNonNullIsNull(false, new Class[0]),
        nullsAreSortedHigh(false, new Class[0]),
        nullsAreSortedLow(false, new Class[0]),
        nullsAreSortedAtStart(false, new Class[0]),
        nullsAreSortedAtEnd(false, new Class[0]),
        othersDeletesAreVisible(false, Integer.TYPE),
        othersInsertsAreVisible(false, Integer.TYPE),
        othersUpdatesAreVisible(false, Integer.TYPE),
        ownDeletesAreVisible(false, Integer.TYPE),
        ownInsertsAreVisible(false, Integer.TYPE),
        ownUpdatesAreVisible(false, Integer.TYPE),
        storesLowerCaseIdentifiers(false, new Class[0]),
        storesLowerCaseQuotedIdentifiers(false, new Class[0]),
        storesMixedCaseIdentifiers(false, new Class[0]),
        storesMixedCaseQuotedIdentifiers(false, new Class[0]),
        storesUpperCaseIdentifiers(false, new Class[0]),
        storesUpperCaseQuotedIdentifiers(false, new Class[0]),
        supportsAlterTableWithAddColumn(false, new Class[0]),
        supportsAlterTableWithDropColumn(false, new Class[0]),
        supportsANSI92EntryLevelSQL(false, new Class[0]),
        supportsANSI92FullSQL(false, new Class[0]),
        supportsANSI92IntermediateSQL(false, new Class[0]),
        supportsBatchUpdates(false, new Class[0]),
        supportsCatalogsInDataManipulation(false, new Class[0]),
        supportsCatalogsInIndexDefinitions(false, new Class[0]),
        supportsCatalogsInPrivilegeDefinitions(false, new Class[0]),
        supportsCatalogsInProcedureCalls(false, new Class[0]),
        supportsCatalogsInTableDefinitions(false, new Class[0]),
        supportsColumnAliasing(false, new Class[0]),
        supportsConvert(false, new Class[0]),
        supportsCoreSQLGrammar(false, new Class[0]),
        supportsCorrelatedSubqueries(false, new Class[0]),
        supportsDataDefinitionAndDataManipulationTransactions(false, new Class[0]),
        supportsDataManipulationTransactionsOnly(false, new Class[0]),
        supportsExtendedSQLGrammar(false, new Class[0]),
        supportsGroupBy(false, new Class[0]),
        supportsFullOuterJoins(false, new Class[0]),
        supportsGetGeneratedKeys(false, new Class[0]),
        supportsGroupByBeyondSelect(false, new Class[0]),
        supportsGroupByUnrelated(false, new Class[0]),
        supportsIntegrityEnhancementFacility(false, new Class[0]),
        supportsLikeEscapeClause(false, new Class[0]),
        supportsLimitedOuterJoins(false, new Class[0]),
        supportsMinimumSQLGrammar(false, new Class[0]),
        supportsMixedCaseIdentifiers(false, new Class[0]),
        supportsMultipleOpenResults(false, new Class[0]),
        supportsMultipleResultSets(false, new Class[0]),
        supportsMultipleTransactions(false, new Class[0]),
        supportsDifferentTableCorrelationNames(false, new Class[0]),
        supportsExpressionsInOrderBy(false, new Class[0]),
        supportsMixedCaseQuotedIdentifiers(false, new Class[0]),
        supportsNamedParameters(false, new Class[0]),
        supportsNonNullableColumns(false, new Class[0]),
        supportsOrderByUnrelated(false, new Class[0]),
        supportsOuterJoins(false, new Class[0]),
        supportsPositionedDelete(false, new Class[0]),
        supportsPositionedUpdate(false, new Class[0]),
        supportsRefCursors(false, new Class[0]),
        supportsResultSetConcurrency(false, Integer.TYPE, Integer.TYPE),
        supportsResultSetHoldability(false, Integer.TYPE),
        supportsResultSetType(false, Integer.TYPE),
        supportsSavepoints(false, new Class[0]),
        supportsSchemasInDataManipulation(false, new Class[0]),
        supportsSchemasInIndexDefinitions(false, new Class[0]),
        supportsSchemasInPrivilegeDefinitions(false, new Class[0]),
        supportsSchemasInProcedureCalls(false, new Class[0]),
        supportsSchemasInTableDefinitions(false, new Class[0]),
        supportsSelectForUpdate(false, new Class[0]),
        supportsStatementPooling(false, new Class[0]),
        supportsStoredFunctionsUsingCallSyntax(false, new Class[0]),
        supportsStoredProcedures(false, new Class[0]),
        supportsSubqueriesInComparisons(false, new Class[0]),
        supportsSubqueriesInExists(false, new Class[0]),
        supportsSubqueriesInIns(false, new Class[0]),
        supportsSubqueriesInQuantifieds(false, new Class[0]),
        supportsTableCorrelationNames(false, new Class[0]),
        supportsTransactionIsolationLevel(false, Integer.TYPE),
        supportsTransactions(false, new Class[0]),
        supportsUnion(false, new Class[0]),
        supportsUnionAll(false, new Class[0]),
        updatesAreDetected(false, Integer.TYPE),
        usesLocalFiles(false, new Class[0]),
        usesLocalFilePerTable(false, new Class[0]);

        private final Method method;
        private final Object defaultValue;
        private static final Map<String, MethodWithDefault> MAP;

        private MethodWithDefault(Object defaultValue, Class ... parameterTypes) {
            this.method = Objects.requireNonNull(MethodWithDefault.findMethod(this.name(), parameterTypes));
            this.defaultValue = defaultValue;
        }

        static MethodWithDefault lookup(Method method) {
            return MAP.get(method.getName());
        }

        private static Method findMethod(String methodName, Class ... parameterTypes) {
            try {
                return DatabaseMetaData.class.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError("not found: " + methodName + Arrays.asList(parameterTypes), e);
            }
        }

        static {
            MAP = new HashMap<String, MethodWithDefault>();
            for (MethodWithDefault methodWithDefault : MethodWithDefault.values()) {
                MAP.put(methodWithDefault.method.getName(), methodWithDefault);
            }
        }
    }
}

