/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import sqlline.Rows;
import sqlline.SqlLine;
import sqlline.WrappedSqlException;

class BufferedRows
extends Rows {
    private final ResultSet rs;
    private final Rows.Row columnNames;
    private final int columnCount;
    private final int limit;
    private List<Rows.Row> list;
    private Iterator<Rows.Row> iterator;
    private int batch = 0;
    private int[] max = null;

    BufferedRows(SqlLine sqlLine, ResultSet rs) throws SQLException {
        super(sqlLine, rs);
        this.rs = rs;
        this.limit = sqlLine.getOpts().getIncrementalBufferRows();
        this.columnCount = this.rsMeta.getColumnCount();
        this.columnNames = new Rows.Row(this, this.columnCount);
        this.list = this.nextList();
        this.iterator = this.list.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator.hasNext()) {
            return true;
        }
        try {
            this.list = this.nextList();
            this.iterator = this.list.iterator();
            return this.iterator.hasNext();
        }
        catch (SQLException ex) {
            throw new WrappedSqlException(ex);
        }
    }

    @Override
    public Rows.Row next() {
        Rows.Row row = this.iterator.next();
        if (this.batch > 0) {
            this.normalizeWidth(this.sqlLine.getOpts().getMaxColumnWidth(), row);
        }
        return row;
    }

    @Override
    void normalizeWidths(int maxColumnWidth) {
        for (Rows.Row row : this.list) {
            this.normalizeWidth(maxColumnWidth, row);
        }
    }

    private void normalizeWidth(int maxColumnWidth, Rows.Row row) {
        if (this.max == null) {
            this.max = new int[row.values.length];
        }
        for (int j = 0; j < this.max.length; ++j) {
            int currentMaxWidth = Math.max(this.max[j], row.sizes[j]);
            this.max[j] = maxColumnWidth > 0 ? Math.min(currentMaxWidth, maxColumnWidth) : currentMaxWidth;
        }
        row.sizes = this.max;
    }

    private List<Rows.Row> nextList() throws SQLException {
        LinkedList<Rows.Row> list = new LinkedList<Rows.Row>();
        if (this.batch == 0) {
            list.add(this.columnNames);
        }
        if (this.limit >= 0 && this.batch == 0) {
            int counter = 0;
            while (counter++ < this.limit && this.rs.next()) {
                list.add(new Rows.Row(this, this.columnCount, this.rs));
            }
        } else {
            while (this.rs.next()) {
                Rows.Row row = new Rows.Row(this, this.columnCount, this.rs);
                list.add(row);
            }
        }
        ++this.batch;
        return list;
    }
}

