package sqlite4a;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * @author Daniel Serdyukov
 */
public class SQLiteValue {

    private final long mValuePtr;

    SQLiteValue(long valuePtr) {
        mValuePtr = valuePtr;
    }

    private static native long nativeLongValue(long valuePtr);

    private static native String nativeStringValue(long valuePtr);

    private static native double nativeDoubleValue(long valuePtr);

    private static native byte[] nativeBlobValue(long valuePtr);

    public long longValue() {
        return nativeLongValue(mValuePtr);
    }

    @Nullable
    public String stringValue() {
        return nativeStringValue(mValuePtr);
    }

    public double doubleValue() {
        return nativeDoubleValue(mValuePtr);
    }

    @NonNull
    public byte[] blobValue() {
        return nativeBlobValue(mValuePtr);
    }

}
