package sqlite4a;

import android.support.annotation.NonNull;

/**
 * @author Daniel Serdyukov
 */
class SQLiteCustomFunc {

    private final SQLiteFunc mFunc;

    SQLiteCustomFunc(@NonNull SQLiteFunc func) {
        mFunc = func;
    }

    void call(long contextPtr, long[] valuePtrs) {
        final SQLiteValue[] values = new SQLiteValue[valuePtrs.length];
        for (int i = 0; i < valuePtrs.length; ++i) {
            values[i] = new SQLiteValue(valuePtrs[i]);
        }
        mFunc.call(new SQLiteContext(contextPtr), values);
    }

}
