package sqlite4a;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * @author Daniel Serdyukov
 */
public class SQLiteCursor {

    private final long mStmtPtr;

    SQLiteCursor(long stmtPtr) {
        mStmtPtr = stmtPtr;
    }

    private static native boolean nativeStep(long stmtPtr);

    private static native int nativeGetColumnCount(long stmtPtr);

    private static native String nativeGetColumnName(long stmtPtr, int index);

    private static native long nativeGetColumnLong(long stmtPtr, int index);

    private static native String nativeGetColumnString(long stmtPtr, int index);

    private static native double nativeGetColumnDouble(long stmtPtr, int index);

    private static native byte[] nativeGetColumnBlob(long stmtPtr, int index);

    public boolean step() {
        return nativeStep(mStmtPtr);
    }

    public int getColumnCount() {
        return nativeGetColumnCount(mStmtPtr);
    }

    @NonNull
    public String getColumnName(@IntRange(from = 0) int index) {
        return nativeGetColumnName(mStmtPtr, index);
    }

    public long getColumnLong(@IntRange(from = 0) int index) {
        return nativeGetColumnLong(mStmtPtr, index);
    }

    @Nullable
    public String getColumnString(@IntRange(from = 0) int index) {
        return nativeGetColumnString(mStmtPtr, index);
    }

    public double getColumnDouble(@IntRange(from = 0) int index) {
        return nativeGetColumnDouble(mStmtPtr, index);
    }

    @NonNull
    public byte[] getColumnBlob(@IntRange(from = 0) int index) {
        return nativeGetColumnBlob(mStmtPtr, index);
    }

}
