package sqlite4a;

import android.support.annotation.NonNull;

/**
 * @author Daniel Serdyukov
 */
@SuppressWarnings("ConstantConditions")
public class SQLiteContext {

    private final long mContextPtr;

    SQLiteContext(long contextPtr) {
        mContextPtr = contextPtr;
    }

    private static native void nativeResultLong(long contextPtr, long result);

    private static native void nativeResultText(long contextPtr, String result);

    private static native void nativeResultDouble(long contextPtr, double result);

    private static native void nativeResultBlob(long contextPtr, byte[] result);

    public void resultLong(long result) {
        nativeResultLong(mContextPtr, result);
    }

    public void resultText(@NonNull String result) {
        if (result != null) {
            nativeResultText(mContextPtr, result);
        }
    }

    public void resultDouble(double result) {
        nativeResultDouble(mContextPtr, result);
    }

    public void resultBlob(@NonNull byte[] result) {
        if (result != null) {
            nativeResultBlob(mContextPtr, result);
        }
    }

}
