package sqlite4a;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;

import java.io.Closeable;

/**
 * @author Daniel Serdyukov
 */
public interface SQLiteStmt extends Closeable {

    @NonNull
    String getSql();

    void reset();

    void clearBindings();

    void bindNull(@IntRange(from = 1) int index);

    void bindLong(@IntRange(from = 1) int index, long value);

    void bindDouble(@IntRange(from = 1) int index, double value);

    void bindString(@IntRange(from = 1) int index, @NonNull String value);

    void bindBlob(@IntRange(from = 1) int index, @NonNull byte[] value);

    int execute();

    @NonNull
    SQLiteRowSet executeSelect();

    boolean isBusy();

    @Override
    void close();

}
