package sqlite4a;

import android.support.annotation.IntDef;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @author Daniel Serdyukov
 */
public interface SQLiteRow {

    int SQLITE_INTEGER = 1;

    int SQLITE_FLOAT = 2;

    int SQLITE_TEXT = 3;

    int SQLITE_BLOB = 4;

    int SQLITE_NULL = 5;

    int getColumnCount();

    @NonNull
    String getColumnName(@IntRange(from = 0) int columnIndex);

    @ColumnType
    int getColumnType(@IntRange(from = 0) int columnIndex);

    long getColumnLong(@IntRange(from = 0) int columnIndex);

    double getColumnDouble(@IntRange(from = 0) int columnIndex);

    String getColumnString(@IntRange(from = 0) int columnIndex);

    byte[] getColumnBlob(@IntRange(from = 0) int columnIndex);

    @IntDef({SQLITE_INTEGER, SQLITE_FLOAT, SQLITE_TEXT, SQLITE_BLOB, SQLITE_NULL})
    @Retention(RetentionPolicy.SOURCE)
    @interface ColumnType {
    }

}
