package sqlite4a;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;

/**
 * @author Daniel Serdyukov
 */
class SQLiteJniStmt implements SQLiteStmt {

    private final long mStmtPtr;

    SQLiteJniStmt(long dbPtr, @NonNull String sql) {
        mStmtPtr = nativePrepare(dbPtr, sql);
    }

    private static native long nativePrepare(long dbPtr, String sql);

    private static native String nativeGetSql(long stmtPtr);

    private static native void nativeReset(long stmtPtr);

    private static native void nativeClearBindings(long stmtPtr);

    private static native void nativeBindNull(long stmtPtr, int index);

    private static native void nativeBindLong(long stmtPtr, int index, long value);

    private static native void nativeBindDouble(long stmtPtr, int index, double value);

    private static native void nativeBindString(long stmtPtr, int index, String value);

    private static native void nativeBindBlob(long stmtPtr, int index, byte[] value);

    private static native int nativeExecute(long stmtPtr);

    private static native boolean nativeIsBusy(long stmtPtr);

    private static native void nativeFinalize(long stmtPtr);

    @NonNull
    @Override
    public String getSql() {
        return nativeGetSql(mStmtPtr);
    }

    @Override
    public void reset() {
        nativeReset(mStmtPtr);
    }

    @Override
    public void clearBindings() {
        nativeClearBindings(mStmtPtr);
    }

    @Override
    public void bindNull(@IntRange(from = 1) int index) {
        nativeBindNull(mStmtPtr, index);
    }

    @Override
    public void bindLong(@IntRange(from = 1) int index, long value) {
        nativeBindLong(mStmtPtr, index, value);
    }

    @Override
    public void bindDouble(@IntRange(from = 1) int index, double value) {
        nativeBindDouble(mStmtPtr, index, value);
    }

    @Override
    public void bindString(@IntRange(from = 1) int index, @NonNull String value) {
        nativeBindString(mStmtPtr, index, value);
    }

    @Override
    public void bindBlob(@IntRange(from = 1) int index, @NonNull byte[] value) {
        nativeBindBlob(mStmtPtr, index, value);
    }

    @Override
    public int execute() {
        return nativeExecute(mStmtPtr);
    }

    @NonNull
    @Override
    public SQLiteRowSet executeSelect() {
        return new SQLiteJniRowSet(mStmtPtr);
    }

    @Override
    public boolean isBusy() {
        return nativeIsBusy(mStmtPtr);
    }

    @Override
    public void close() {
        nativeFinalize(mStmtPtr);
    }

}
