package sqlite4a;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;

/**
 * @author Daniel Serdyukov
 */
class SQLiteJniRowSet implements SQLiteRowSet {

    private final long mStmtPtr;

    SQLiteJniRowSet(long stmtPtr) {
        mStmtPtr = stmtPtr;
    }

    private static native boolean nativeStep(long stmtPtr);

    private static native int nativeGetColumnCount(long stmtPtr);

    private static native String nativeGetColumnName(long stmtPtr, int index);

    @SQLiteRow.ColumnType
    private static native int nativeGetColumnType(long stmtPtr, int index);

    private static native long nativeGetColumnLong(long stmtPtr, int index);

    private static native double nativeGetColumnDouble(long stmtPtr, int index);

    private static native String nativeGetColumnString(long stmtPtr, int index);

    private static native byte[] nativeGetColumnBlob(long stmtPtr, int index);

    public boolean step() {
        return nativeStep(mStmtPtr);
    }

    @Override
    public int getColumnCount() {
        return nativeGetColumnCount(mStmtPtr);
    }

    @NonNull
    @Override
    public String getColumnName(@IntRange(from = 0) int columnIndex) {
        return nativeGetColumnName(mStmtPtr, columnIndex);
    }

    @SQLiteRow.ColumnType
    @Override
    public int getColumnType(@IntRange(from = 0) int columnIndex) {
        return nativeGetColumnType(mStmtPtr, columnIndex);
    }

    @Override
    public long getColumnLong(@IntRange(from = 0) int columnIndex) {
        return nativeGetColumnLong(mStmtPtr, columnIndex);
    }

    @Override
    public double getColumnDouble(@IntRange(from = 0) int columnIndex) {
        return nativeGetColumnDouble(mStmtPtr, columnIndex);
    }

    @Override
    public String getColumnString(@IntRange(from = 0) int columnIndex) {
        return nativeGetColumnString(mStmtPtr, columnIndex);
    }

    @Override
    public byte[] getColumnBlob(@IntRange(from = 0) int columnIndex) {
        return nativeGetColumnBlob(mStmtPtr, columnIndex);
    }

}
