package sqlite4a;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;

import java.io.Closeable;

/**
 * @author Daniel Serdyukov
 */
public class SQLiteStmt implements Closeable {

    private final long mStmtPtr;

    SQLiteStmt(long stmtPtr) {
        mStmtPtr = stmtPtr;
    }

    private static native String nativeGetSql(long stmtPtr);

    private static native void nativeReset(long stmtPtr);

    private static native void nativeClearBindings(long stmtPtr);

    private static native void nativeBindNull(long stmtPtr, int index);

    private static native void nativeBindLong(long stmtPtr, int index, long value);

    private static native void nativeBindDouble(long stmtPtr, int index, double value);

    private static native void nativeBindString(long stmtPtr, int index, String value);

    private static native void nativeBindBlob(long stmtPtr, int index, byte[] value);

    private static native int nativeExecute(long stmtPtr);

    private static native boolean nativeIsBusy(long stmtPtr);

    private static native void nativeFinalize(long stmtPtr);

    @NonNull
    public String getSql() {
        return nativeGetSql(mStmtPtr);
    }

    public void reset() {
        nativeReset(mStmtPtr);
    }

    public void clearBindings() {
        nativeClearBindings(mStmtPtr);
    }

    public void bindNull(@IntRange(from = 1) int index) {
        nativeBindNull(mStmtPtr, index);
    }

    public void bindLong(@IntRange(from = 1) int index, long value) {
        nativeBindLong(mStmtPtr, index, value);
    }

    public void bindDouble(@IntRange(from = 1) int index, double value) {
        nativeBindDouble(mStmtPtr, index, value);
    }

    public void bindString(@IntRange(from = 1) int index, @NonNull String value) {
        nativeBindString(mStmtPtr, index, value);
    }

    public void bindBlob(@IntRange(from = 1) int index, @NonNull byte[] value) {
        nativeBindBlob(mStmtPtr, index, value);
    }

    public int execute() {
        return nativeExecute(mStmtPtr);
    }

    @NonNull
    public SQLiteRowSet executeSelect() {
        return new SQLiteRowSet(mStmtPtr);
    }

    public boolean isBusy() {
        return nativeIsBusy(mStmtPtr);
    }

    @Override
    public void close() {
        nativeFinalize(mStmtPtr);
    }

}
