/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiTemplate;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.HeuristicCompletionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSuspensionNotSupportedException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.jta.JtaTransactionObject;
import org.springframework.transaction.jta.UserTransactionAdapter;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class JtaTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean,
Serializable {
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    public static final String FALLBACK_TRANSACTION_MANAGER_NAME = "java:/TransactionManager";
    private transient JndiTemplate jndiTemplate = new JndiTemplate();
    private String userTransactionName = "java:comp/UserTransaction";
    private transient UserTransaction userTransaction;
    private String transactionManagerName;
    private transient TransactionManager transactionManager;
    private boolean autodetectTransactionManager = true;
    static /* synthetic */ Class class$javax$transaction$UserTransaction;
    static /* synthetic */ Class class$javax$transaction$TransactionManager;

    public JtaTransactionManager() {
        this.setNestedTransactionAllowed(true);
    }

    public JtaTransactionManager(UserTransaction userTransaction) {
        this();
        this.userTransaction = userTransaction;
        this.afterPropertiesSet();
    }

    public JtaTransactionManager(UserTransaction userTransaction, TransactionManager transactionManager) {
        this();
        this.userTransaction = userTransaction;
        this.transactionManager = transactionManager;
        this.afterPropertiesSet();
    }

    public JtaTransactionManager(TransactionManager transactionManager) {
        this();
        this.userTransactionName = null;
        this.transactionManager = transactionManager;
        this.afterPropertiesSet();
    }

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        if (jndiTemplate == null) {
            throw new IllegalArgumentException("jndiTemplate must not be null");
        }
        this.jndiTemplate = jndiTemplate;
    }

    public JndiTemplate getJndiTemplate() {
        return this.jndiTemplate;
    }

    public void setUserTransactionName(String userTransactionName) {
        this.userTransactionName = userTransactionName;
    }

    public void setUserTransaction(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    public UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public void setTransactionManagerName(String transactionManagerName) {
        this.transactionManagerName = transactionManagerName;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setAutodetectTransactionManager(boolean autodetectTransactionManager) {
        this.autodetectTransactionManager = autodetectTransactionManager;
    }

    public void afterPropertiesSet() throws TransactionSystemException {
        if (this.userTransaction == null) {
            this.userTransaction = this.userTransactionName != null ? this.lookupUserTransaction(this.userTransactionName) : this.retrieveUserTransaction();
        }
        if (this.transactionManager == null) {
            this.transactionManager = this.transactionManagerName != null ? this.lookupTransactionManager(this.transactionManagerName) : this.retrieveTransactionManager();
        }
        if (this.transactionManager == null && this.autodetectTransactionManager) {
            if (this.userTransaction instanceof TransactionManager) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("JTA UserTransaction object [" + this.userTransaction + "] implements TransactionManager"));
                }
                this.transactionManager = (TransactionManager)this.userTransaction;
            } else {
                try {
                    this.transactionManager = this.lookupTransactionManager(FALLBACK_TRANSACTION_MANAGER_NAME);
                }
                catch (TransactionSystemException ex) {
                    this.logger.debug((Object)"No JTA TransactionManager found at fallback JNDI location", (Throwable)((Object)ex));
                }
            }
        }
        if (this.userTransaction == null && this.transactionManager != null) {
            this.userTransaction = this.transactionManager instanceof UserTransaction ? (UserTransaction)this.transactionManager : new UserTransactionAdapter(this.transactionManager);
        }
        if (this.userTransaction != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using JTA UserTransaction: " + this.userTransaction));
            }
        } else {
            throw new IllegalArgumentException("Either 'userTransaction' or 'userTransactionName' or 'transactionManager' or 'transactionManagerName' must be set");
        }
        if (this.transactionManager != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using JTA TransactionManager: " + this.transactionManager));
            }
        } else {
            this.logger.warn((Object)"No JTA TransactionManager found: transaction suspension not available");
        }
    }

    protected UserTransaction lookupUserTransaction(String userTransactionName) throws TransactionSystemException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving JTA UserTransaction from JNDI location [" + userTransactionName + "]"));
            }
            UserTransaction ut = (UserTransaction)this.getJndiTemplate().lookup(userTransactionName, class$javax$transaction$UserTransaction == null ? (class$javax$transaction$UserTransaction = JtaTransactionManager.class$("javax.transaction.UserTransaction")) : class$javax$transaction$UserTransaction);
            return ut;
        }
        catch (NamingException ex) {
            throw new TransactionSystemException("JTA UserTransaction is not available at JNDI location [" + userTransactionName + "]", ex);
        }
    }

    protected TransactionManager lookupTransactionManager(String transactionManagerName) throws TransactionSystemException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving JTA TransactionManager from JNDI location [" + transactionManagerName + "]"));
            }
            TransactionManager tm = (TransactionManager)this.getJndiTemplate().lookup(transactionManagerName, class$javax$transaction$TransactionManager == null ? (class$javax$transaction$TransactionManager = JtaTransactionManager.class$("javax.transaction.TransactionManager")) : class$javax$transaction$TransactionManager);
            return tm;
        }
        catch (NamingException ex) {
            throw new TransactionSystemException("JTA TransactionManager is not available at JNDI location [" + transactionManagerName + "]", ex);
        }
    }

    protected UserTransaction retrieveUserTransaction() throws TransactionSystemException {
        return null;
    }

    protected TransactionManager retrieveTransactionManager() throws TransactionSystemException {
        return null;
    }

    protected Object doGetTransaction() {
        return new JtaTransactionObject(this.getUserTransaction());
    }

    protected boolean isExistingTransaction(Object transaction) {
        try {
            return this.getUserTransaction().getStatus() != 6;
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on getStatus", ex);
        }
    }

    protected boolean useSavepointForNestedTransaction() {
        return false;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        this.logger.debug((Object)"Beginning JTA transaction");
        try {
            this.doJtaBegin(definition);
        }
        catch (NotSupportedException ex) {
            throw new NestedTransactionNotSupportedException("JTA implementation does not support nested transactions", ex);
        }
        catch (UnsupportedOperationException ex) {
            throw new NestedTransactionNotSupportedException("JTA implementation does not support nested transactions", ex);
        }
        catch (SystemException ex) {
            throw new CannotCreateTransactionException("JTA failure on begin", ex);
        }
    }

    protected void doJtaBegin(TransactionDefinition definition) throws NotSupportedException, SystemException {
        this.applyIsolationLevel(definition.getIsolationLevel());
        this.applyTimeout(definition.getTimeout());
        this.getUserTransaction().begin();
    }

    protected void applyIsolationLevel(int isolationLevel) throws InvalidIsolationLevelException, SystemException {
        if (isolationLevel != -1) {
            throw new InvalidIsolationLevelException("JtaTransactionManager does not support custom isolation levels");
        }
    }

    protected void applyTimeout(int timeout) throws SystemException {
        if (timeout > -1) {
            this.getUserTransaction().setTransactionTimeout(timeout);
        }
    }

    protected Object doSuspend(Object transaction) {
        if (this.getTransactionManager() == null) {
            throw new TransactionSuspensionNotSupportedException("JtaTransactionManager needs a JTA TransactionManager for suspending a transaction - specify the 'transactionManager' or 'transactionManagerName' property");
        }
        this.logger.debug((Object)"Suspending JTA transaction");
        try {
            return this.doJtaSuspend();
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on suspend", ex);
        }
    }

    protected Transaction doJtaSuspend() throws SystemException {
        return this.getTransactionManager().suspend();
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        if (this.getTransactionManager() == null) {
            throw new TransactionSuspensionNotSupportedException("JtaTransactionManager needs a JTA TransactionManager for suspending a transaction - specify the 'transactionManager' or 'transactionManagerName' property");
        }
        this.logger.debug((Object)"Resuming JTA transaction");
        try {
            this.doJtaResume((Transaction)suspendedResources);
        }
        catch (InvalidTransactionException ex) {
            throw new IllegalTransactionStateException("Tried to resume invalid JTA transaction", ex);
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on resume", ex);
        }
    }

    protected void doJtaResume(Transaction suspendedTransaction) throws InvalidTransactionException, SystemException {
        this.getTransactionManager().resume(suspendedTransaction);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        this.logger.debug((Object)"Committing JTA transaction");
        try {
            this.getUserTransaction().commit();
        }
        catch (RollbackException ex) {
            throw new UnexpectedRollbackException("JTA transaction rolled back", ex);
        }
        catch (HeuristicMixedException ex) {
            throw new HeuristicCompletionException(3, (Throwable)ex);
        }
        catch (HeuristicRollbackException ex) {
            throw new HeuristicCompletionException(2, (Throwable)ex);
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on commit", ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        this.logger.debug((Object)"Rolling back JTA transaction");
        try {
            this.getUserTransaction().rollback();
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on rollback", ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        if (status.isDebug()) {
            this.logger.debug((Object)"Setting JTA transaction rollback-only");
        }
        try {
            this.getUserTransaction().setRollbackOnly();
        }
        catch (IllegalStateException ex) {
            throw new NoTransactionException("No active JTA transaction");
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on setRollbackOnly", ex);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        try {
            ois.defaultReadObject();
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Failed to deserialize JtaTransactionManager - check that JTA and Spring transaction libraries are available on the client side: " + ex.getMessage());
        }
        this.jndiTemplate = new JndiTemplate();
        this.userTransaction = this.lookupUserTransaction(this.userTransactionName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

