/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.support.TransactionSynchronization;

public abstract class TransactionSynchronizationManager {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$transaction$support$TransactionSynchronizationManager == null ? (class$org$springframework$transaction$support$TransactionSynchronizationManager = TransactionSynchronizationManager.class$("org.springframework.transaction.support.TransactionSynchronizationManager")) : class$org$springframework$transaction$support$TransactionSynchronizationManager));
    private static ThreadLocal resources = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    private static final ThreadLocal synchronizations = new ThreadLocal();
    static /* synthetic */ Class class$org$springframework$transaction$support$TransactionSynchronizationManager;

    public static Map getResourceMap() {
        return (Map)resources.get();
    }

    public static boolean hasResource(Object key) {
        return TransactionSynchronizationManager.getResourceMap().containsKey(key);
    }

    public static Object getResource(Object key) {
        Object value = TransactionSynchronizationManager.getResourceMap().get(key);
        if (value != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved value [" + value + "] for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]"));
        }
        return value;
    }

    public static void bindResource(Object key, Object value) {
        if (TransactionSynchronizationManager.hasResource(key)) {
            throw new IllegalStateException("Already a value for key [" + key + "] bound to thread");
        }
        TransactionSynchronizationManager.getResourceMap().put(key, value);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bound value [" + value + "] for key [" + key + "] to thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    public static Object unbindResource(Object key) {
        if (!TransactionSynchronizationManager.hasResource(key)) {
            throw new IllegalStateException("No value for key [" + key + "] bound to thread");
        }
        Object value = TransactionSynchronizationManager.getResourceMap().remove(key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed value [" + value + "] for key [" + key + "] from thread [" + Thread.currentThread().getName() + "]"));
        }
        return value;
    }

    public static boolean isSynchronizationActive() {
        return synchronizations.get() != null;
    }

    public static void initSynchronization() throws IllegalStateException {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot activate transaction synchronization - already active");
        }
        logger.debug((Object)"Initializing transaction synchronization");
        synchronizations.set(new ArrayList());
    }

    public static void registerSynchronization(TransactionSynchronization synchronization) throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        ((List)synchronizations.get()).add(synchronization);
    }

    public static List getSynchronizations() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        return Collections.unmodifiableList((List)synchronizations.get());
    }

    public static void clearSynchronization() throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot deactivate transaction synchronization - not active");
        }
        logger.debug((Object)"Clearing transaction synchronization");
        synchronizations.set(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

