/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import javax.naming.NamingException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.util.StringUtils;

public abstract class JndiObjectLocator
extends JndiLocatorSupport
implements InitializingBean {
    private String jndiName;
    private Class expectedType;

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setExpectedType(Class expectedType) {
        this.expectedType = expectedType;
    }

    public Class getExpectedType() {
        return this.expectedType;
    }

    public void afterPropertiesSet() throws NamingException {
        if (!StringUtils.hasLength((String)this.getJndiName())) {
            throw new IllegalArgumentException("jndiName is required");
        }
    }

    protected Object lookup() throws NamingException {
        Object jndiObject = this.lookup(this.getJndiName());
        if (this.getExpectedType() != null && !this.getExpectedType().isInstance(jndiObject)) {
            throw new NamingException("Located JNDI object [" + jndiObject + "] is not assignable to expected type [" + this.expectedType.getName() + "]");
        }
        return jndiObject;
    }
}

