/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.aop.support.UnionPointcut;

public abstract class Pointcuts {
    public static final Pointcut SETTERS = SetterPointcut.INSTANCE;
    public static final Pointcut GETTERS = GetterPointcut.INSTANCE;

    public static Pointcut union(Pointcut a, Pointcut b) {
        return new UnionPointcut(a, b);
    }

    public static Pointcut intersection(Pointcut a, Pointcut b) {
        return new ComposablePointcut(a.getClassFilter(), a.getMethodMatcher()).intersection(b);
    }

    public static boolean matches(Pointcut pc, Method m, Class targetClass, Object[] arguments) {
        MethodMatcher mm;
        if (pc == Pointcut.TRUE) {
            return true;
        }
        if (pc.getClassFilter().matches(targetClass) && (mm = pc.getMethodMatcher()).matches(m, targetClass)) {
            return mm.isRuntime() ? mm.matches(m, targetClass, arguments) : true;
        }
        return false;
    }

    public static boolean equals(Pointcut a, Pointcut b) {
        return a.getClassFilter() == b.getClassFilter() && a.getMethodMatcher() == b.getMethodMatcher();
    }

    private static class GetterPointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        public static GetterPointcut INSTANCE = new GetterPointcut();

        private GetterPointcut() {
        }

        public boolean matches(Method m, Class targetClass) {
            return m.getName().startsWith("get") && m.getParameterTypes().length == 0;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static class SetterPointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        public static SetterPointcut INSTANCE = new SetterPointcut();

        private SetterPointcut() {
        }

        public boolean matches(Method m, Class targetClass) {
            return m.getName().startsWith("set") && m.getParameterTypes().length == 1 && m.getReturnType() == Void.TYPE;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

