(ns hemlock.core
  (:require
   [clojure.zip :as z])
        
  (:require-macros
   [hemlock.core :refer [defcurried]]))

;; ---------------------------------------------------------------------
;; Utilities

;;; Macro helpers

     
                             
                                                                   
           
                         
                       
              
                            

     
                                 
                                            
           
                               

     
                         
                                                     
                   
           
                                 

;;; Currying

     
                          
                                   
             
                                                     
                        
                         
                                        
                                                  
                           
                                                            
                                                   
                                                     
                                         
                        

                    
                              
                                                   
               
                                              
                                 
                          
                          
                    
                            
                        
                          
                                                    
                    
                                                          
                              
                        
                                    
                               
                                       
                                               
                                        
                                                               
                                       
                   
                                            
                                             

(defcurried ^:private applicate
  "Applies the composition of fs to x."
  [x fs]
  (reduce (fn [x' f] (f x')) x fs))


;; ---------------------------------------------------------------------
;; Location functions

(def pass
  (constantly identity))


(defcurried child
  "Like clojure.zip/append-child but takes it's arguments in reverse."
  [x loc]
  (if (z/branch? loc)
    (z/append-child loc x)
    (z/insert-left loc x)))


(defcurried children
  [xs loc]
  (applicate loc (for [x xs]
                   (cond
                     (fn? x)
                     x

                     (sequential? x)
                     (children x)

                     :else
                     (child x)))))


(defn edit
  "Given a fn f and variable number of arguments return a function which
  takes a zipper and applies zip/edit to it with f and args"
  [f & args]
  (fn [loc]
    (apply z/edit loc f args)))


(defcurried builder
  "Apply a variable number of edits to the zipper created by 
  (zipper root-node) and return it's value."
  [zipper root-node]
  (fn [& edits]
    (z/root (children edits (zipper root-node)))))


;; ---------------------------------------------------------------------
;; Term functions

(defn make-term
  "Return a function f which accepts a variable number of unary 
  functions which operate on a zipper and returns a unary function g of
  a zipper that appends tag and applicates edits to it. Before g returns
  the editted tag may be validated with validator. g returns focus to the
  to the original location."
  [{:keys [node pre post]
    :or {pre identity
         post identity}}]
  (fn f [& edits]
    (fn g [ploc]
      ;; Run a pre operation on the parent node before applying edits.
      (pre (z/node ploc))
      (let [cloc (-> ploc
                     (z/append-child node)
                     (z/down)
                     (z/rightmost)
                     (applicate edits))]
        ;; Run post operations on the child node after it has been
        ;; appended.
        (post (z/node cloc))
        ;; Return the parent location.
        (z/up cloc)))))


              
                                                                        
                                                                        
                                              
  
     

                    
                                                
                            
                                     
                                               
                         
                     
                                                                 
   
                  
                                           
                         
                                 
                            
                          
                                  
                                
                                            
                                               
                                                     
                         
                                               
                                                   
                                                      


                 
                                   
                       
                                      

;;;;;;;;;;;; This file autogenerated from src/hemlock/core.cljx
