/*
 * Decompiled with CFR 0.152.
 */
package solutions.deepfield.spark.itcase.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import solutions.deepfield.spark.itcase.annotations.SparkITCase;
import solutions.deepfield.spark.itcase.core.util.Booter;

public class TestUtil {
    private Log log;
    private String testTarget;
    private File buildDir;
    private List<Class> testClasses;
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> projectRepos;
    private List<RemoteRepository> pluginRepos;
    private MavenProject project;
    private URLClassLoader classLoader;

    public void init() throws Exception {
        if (this.testTarget == null) {
            this.testTarget = this.buildDir + File.separator + "test-classes";
        }
        this.log.info((CharSequence)("Target directory is [" + this.testTarget + "]"));
        List<String> files = this.buildFiles(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
        this.log.info((CharSequence)("Found deps [" + files.size() + "]"));
        URL[] urls = new URL[files.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = new File(files.get(i)).toURL();
            this.log.info((CharSequence)("Found classpath entry " + urls[i]));
        }
        this.classLoader = new URLClassLoader(urls, null);
        this.testClasses = this.findTestClasses();
        if (this.testClasses.isEmpty()) {
            this.log.info((CharSequence)"No test classes found");
        } else {
            this.log.info((CharSequence)("Found [" + this.testClasses.size() + "] test classes"));
        }
    }

    public List<String> buildFiles(String groupId, String artifactId, String version) throws RepositoryException, ArtifactDescriptorException {
        DefaultArtifact artifact = new DefaultArtifact(groupId + ":" + artifactId + ":" + version);
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setArtifact((Artifact)artifact);
        descriptorRequest.setRepositories(Booter.newRepositories((RepositorySystem)this.repoSystem, (RepositorySystemSession)this.repoSession));
        ArtifactDescriptorResult descriptorResult = this.repoSystem.readArtifactDescriptor(this.repoSession, descriptorRequest);
        CollectRequest request = new CollectRequest();
        request.setRootArtifact((Artifact)artifact);
        request.setDependencies(descriptorResult.getDependencies());
        request.setManagedDependencies(descriptorResult.getManagedDependencies());
        CollectResult result = this.repoSystem.collectDependencies(this.repoSession, request);
        ArrayList<String> resultPaths = new ArrayList<String>();
        DependencyRequest artifactRequest = new DependencyRequest(result.getRoot(), new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                if (node.getDependency() == null) {
                    return true;
                }
                return true;
            }
        });
        DependencyResult dependencyResult = this.repoSystem.resolveDependencies(this.repoSession, artifactRequest);
        for (ArtifactResult artifactResult : dependencyResult.getArtifactResults()) {
            resultPaths.add(artifactResult.getArtifact().getFile().getAbsolutePath());
        }
        return resultPaths;
    }

    public boolean hasTests() {
        return this.testClasses.size() > 0;
    }

    private List<Class> findTestClasses() throws MalformedURLException, ClassNotFoundException {
        File file = new File(this.testTarget);
        URL url = file.toURI().toURL();
        URL[] urls = new URL[]{url};
        URLClassLoader cl = new URLClassLoader(urls, (ClassLoader)this.classLoader);
        Collection<File> classFiles = this.listFiles(file);
        ArrayList<Class> testClasses = new ArrayList<Class>();
        for (File classFile : classFiles) {
            String path = classFile.getAbsolutePath();
            this.log.info((CharSequence)("Found [" + path + "]"));
            if (!path.endsWith(".class") || path.indexOf("$") != -1) continue;
            String shortName = path.substring(this.testTarget.length() + 1, path.length() - 6);
            Object[] parts = StringUtils.split((String)shortName, (String)File.separator);
            String className = StringUtils.join((Object[])parts, (String)".");
            this.log.info((CharSequence)("Found test class [" + className + "]"));
            Class<?> cls = cl.loadClass(className);
            this.log.info((CharSequence)("Class loaded is [" + cls.getCanonicalName() + "]"));
            if (cls.getAnnotation(SparkITCase.class) != null) {
                this.log.info((CharSequence)("Could not find test annotation on [" + cls.getCanonicalName() + "]"));
                continue;
            }
            this.log.info((CharSequence)("Found test annotation on [" + cls.getCanonicalName() + "]"));
            testClasses.add(cls);
        }
        return testClasses;
    }

    public Collection<File> listFiles(File input) {
        return FileUtils.listFiles((File)input, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return true;
            }

            public boolean accept(File dir, String name) {
                return true;
            }
        }, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File dir, String name) {
                return true;
            }

            public boolean accept(File file) {
                return true;
            }
        });
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setTestTarget(String testTarget) {
        this.testTarget = testTarget;
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    public String getTestTarget() {
        return this.testTarget;
    }

    public List<Class> getTestClasses() {
        return this.testClasses;
    }

    public void setRepoSystem(RepositorySystem repoSystem) {
        this.repoSystem = repoSystem;
    }

    public void setRepoSession(RepositorySystemSession repoSession) {
        this.repoSession = repoSession;
    }

    public void setProjectRepos(List<RemoteRepository> projectRepos) {
        this.projectRepos = projectRepos;
    }

    public void setPluginRepos(List<RemoteRepository> pluginRepos) {
        this.pluginRepos = pluginRepos;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }
}

