/*
 * Decompiled with CFR 0.152.
 */
package solutions.deepfield.spark.itcase.maven;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import solutions.deepfield.spark.itcase.annotations.SparkSubmitTestWrapper;
import solutions.deepfield.spark.itcase.annotations.SparkTest;
import solutions.deepfield.spark.itcase.exceptions.SparkITCaseException;
import solutions.deepfield.spark.itcase.maven.BaseSparkITCasePlugin;
import solutions.deepfield.spark.itcase.maven.TestUtil;

@Mojo(name="runTests", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class RunTestsPlugin
extends BaseSparkITCasePlugin {
    @Parameter(property="maven.compiler.testTarget")
    private String testTarget;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> projectRepos;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> pluginRepos;
    @Parameter
    private int threadCount = 5;

    @Override
    public void postExecute() throws Exception {
        Object object;
        OutputStream out3;
        Object version;
        String artifactId;
        TestUtil testUtil = new TestUtil();
        testUtil.setBuildDir(this.buildDir);
        testUtil.setTestTarget(this.testTarget);
        testUtil.setLog(this.getLog());
        testUtil.setProject(this.project);
        testUtil.setPluginRepos(this.pluginRepos);
        testUtil.setProjectRepos(this.projectRepos);
        testUtil.setRepoSession(this.repoSession);
        testUtil.setRepoSystem(this.repoSystem);
        testUtil.init();
        if (!testUtil.hasTests()) {
            throw new SparkITCaseException("No tests found in [" + testUtil.getTestTarget() + "]");
        }
        File outputDir = new File(this.buildDir.getAbsolutePath() + File.separator + "spark-itcase");
        this.getLog().info((CharSequence)("About to delete [" + outputDir.getAbsolutePath() + "]"));
        if (outputDir.exists()) {
            // empty if block
        }
        outputDir.mkdir();
        File testJar = new File(outputDir.getAbsolutePath() + File.separator + this.project.getArtifactId() + "-spark-itcase.jar");
        this.compressZipfile(testUtil.getTestTarget(), testJar.getAbsolutePath());
        StringBuilder dependencyText = new StringBuilder();
        String dependencyFrag = null;
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/dependency_fragment.xml");
        Object object2 = null;
        try (ByteArrayOutputStream out22 = new ByteArrayOutputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)out22);
            dependencyFrag = new String(out22.toByteArray());
        }
        catch (Throwable out22) {
            object2 = out22;
            throw out22;
        }
        finally {
            if (is != null) {
                if (object2 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable out22) {
                        ((Throwable)object2).addSuppressed(out22);
                    }
                } else {
                    is.close();
                }
            }
        }
        List dependencies = this.project.getDependencies();
        for (Dependency dependency : dependencies) {
            String groupId = dependency.getGroupId();
            artifactId = dependency.getArtifactId();
            version = dependency.getVersion();
            if (!dependency.getScope().equalsIgnoreCase("test")) continue;
            this.getLog().info((CharSequence)("Found test dependency [" + groupId + ":" + artifactId + ":" + (String)version + "]"));
            this.addDependency(dependencyText, dependencyFrag, groupId, artifactId, (String)version);
        }
        String groupId = this.project.getGroupId();
        String version2 = this.project.getVersion();
        this.addDependency(dependencyText, dependencyFrag, groupId, this.project.getArtifactId(), version2);
        this.addDependency(dependencyText, dependencyFrag, "solutions.deepfield", "spark-itcase-annotations", this.appUtil.getVersion());
        String pomTemplate = null;
        InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream("/pom_template.xml");
        version = null;
        try {
            out3 = new ByteArrayOutputStream();
            object = null;
            try {
                IOUtils.copy((InputStream)is2, (OutputStream)out3);
                pomTemplate = new String(((ByteArrayOutputStream)out3).toByteArray());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (out3 != null) {
                    if (object != null) {
                        try {
                            ((ByteArrayOutputStream)out3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((ByteArrayOutputStream)out3).close();
                    }
                }
            }
        }
        catch (Throwable out3) {
            version = out3;
            throw out3;
        }
        finally {
            if (is2 != null) {
                if (version != null) {
                    try {
                        is2.close();
                    }
                    catch (Throwable out3) {
                        ((Throwable)version).addSuppressed(out3);
                    }
                } else {
                    is2.close();
                }
            }
        }
        artifactId = this.project.getArtifactId() + "-spark-itcase-wrapper";
        pomTemplate = pomTemplate.replace("@ARTIFACT_ID@", artifactId);
        pomTemplate = pomTemplate.replace("@NAME@", artifactId);
        pomTemplate = pomTemplate.replace("@GROUP_ID@", groupId);
        pomTemplate = pomTemplate.replace("@VERSION@", version2);
        pomTemplate = pomTemplate.replace("@DEPENDENCIES@", dependencyText);
        this.getLog().info((CharSequence)("Dynamic pom with wrapping class is:\n" + pomTemplate));
        File pomFile = new File(outputDir.getAbsolutePath() + File.separator + "pom.xml");
        out3 = new FileOutputStream(pomFile);
        object = null;
        try {
            ((FileOutputStream)out3).write(pomTemplate.getBytes());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (out3 != null) {
                if (object != null) {
                    try {
                        ((FileOutputStream)out3).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((FileOutputStream)out3).close();
                }
            }
        }
        this.deployUtil.deploy(testJar, groupId, artifactId, version2, pomFile);
        ArrayList listOfTests = new ArrayList();
        for (Class testClass : testUtil.getTestClasses()) {
            this.getLog().info((CharSequence)("Running test class [" + testClass + "]"));
            for (Method m : testClass.getMethods()) {
                this.getLog().info((CharSequence)("Found method " + m.getName()));
                if (!this.findTestAnnotation(m)) continue;
                String methodName = m.getName();
                this.getLog().info((CharSequence)("Found test method [" + methodName + "]"));
                ArrayList<String> parameters = new ArrayList<String>();
                parameters.add(testClass.getCanonicalName());
                parameters.add(methodName);
                listOfTests.add(parameters);
            }
        }
        LinkedBlockingQueue<List<String>> queue = new LinkedBlockingQueue<List<String>>(listOfTests);
        queue.iterator();
        CountDownLatch latch = new CountDownLatch(this.threadCount);
        ArrayList<TestRunner> runners = new ArrayList<TestRunner>();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < this.threadCount; ++i) {
            TestRunner runner = new TestRunner(queue, latch, groupId, artifactId, version2);
            runners.add(runner);
            threads.add(new Thread(runner));
        }
        this.getLog().info((CharSequence)("About to execute [" + listOfTests.size() + "] spread over [" + threads.size() + "]"));
        for (Thread t : threads) {
            t.start();
        }
        latch.await();
        Unirest.shutdown();
    }

    public boolean findTestAnnotation(Method m) {
        for (Annotation a : m.getAnnotations()) {
            if (!a.annotationType().getCanonicalName().equals(SparkTest.class.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private void addDependency(StringBuilder dependencyText, String dependencyFrag, String groupId, String artifactId, String version) throws Exception {
        String modFrag = dependencyFrag.replace("@GROUP_ID@", groupId);
        modFrag = modFrag.replace("@ARTIFACT_ID@", artifactId);
        modFrag = modFrag.replace("@VERSION@", version);
        dependencyText.append(modFrag);
        HashMap<String, String> parameters2 = new HashMap<String, String>();
        parameters2.put("artifactId", artifactId);
        parameters2.put("groupId", groupId);
        parameters2.put("version", version);
        HttpResponse resultDep = Unirest.get((String)(this.endpoint + "/artifact/retrieve")).queryString(parameters2).asString();
        this.getLog().info((CharSequence)("Found http response:\n" + (String)resultDep.getBody()));
    }

    public void compressZipfile(String sourceDir, String outputFile) throws Exception {
        this.getLog().info((CharSequence)("Source dir is [" + sourceDir + "]"));
        ZipOutputStream zipFile = new ZipOutputStream(new FileOutputStream(outputFile));
        this.compressDirectoryToZipfile(sourceDir, sourceDir, zipFile);
        ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
        zipFile.putNextEntry(entry);
        String text = "Manifest-Version: 1.0\nTool: sparkItCase";
        zipFile.write(text.getBytes());
        IOUtils.closeQuietly((OutputStream)zipFile);
    }

    private void compressDirectoryToZipfile(String rootDir, String sourceDir, ZipOutputStream out) throws Exception {
        this.getLog().info((CharSequence)("Compressing test dir [" + sourceDir + "]"));
        File sourceDirFile = new File(sourceDir);
        if (sourceDirFile.listFiles() == null) {
            this.getLog().warn((CharSequence)("No files in directory [" + sourceDir + "]"));
            return;
        }
        for (File file : sourceDirFile.listFiles()) {
            if (file.isDirectory()) {
                this.compressDirectoryToZipfile(rootDir, sourceDir + File.separator + file.getName(), out);
                continue;
            }
            ZipEntry entry = new ZipEntry(sourceDir.replace(rootDir + File.separator, "").replaceAll("\\\\", "/") + "/" + file.getName());
            out.putNextEntry(entry);
            FileInputStream in = new FileInputStream(sourceDir + File.separator + file.getName());
            IOUtils.copy((InputStream)in, (OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    class TestRunner
    implements Runnable {
        private LinkedBlockingQueue<List<String>> queue;
        private CountDownLatch latch;
        private String groupId;
        private String artifactId;
        private String version;
        private boolean testHadError = false;

        public TestRunner(LinkedBlockingQueue<List<String>> queue, CountDownLatch latch, String groupId, String artifactId, String version) {
            this.queue = queue;
            this.latch = latch;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        @Override
        public void run() {
            List<String> params = null;
            while (null != (params = this.queue.poll())) {
                try {
                    RunTestsPlugin.this.runUtil.run(SparkSubmitTestWrapper.class.getCanonicalName(), params, this.artifactId, this.groupId, this.version);
                }
                catch (Exception e) {
                    RunTestsPlugin.this.getLog().error((CharSequence)("Error running [" + params + "] " + e.getMessage()), (Throwable)e);
                    this.testHadError = true;
                    break;
                }
            }
            this.latch.countDown();
        }

        public boolean isTestHadError() {
            return this.testHadError;
        }
    }
}

