/*
 * Decompiled with CFR 0.152.
 */
package solutions.deepfield.spark.itcase.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import solutions.deepfield.spark.itcase.annotations.SparkITCase;

public class TestUtil {
    private Log log;
    private String testTarget;
    private File buildDir;
    private List<Class> testClasses;

    public void init() throws MalformedURLException, ClassNotFoundException {
        if (this.testTarget == null) {
            this.testTarget = this.buildDir + File.separator + "test-classes";
        }
        this.log.info((CharSequence)("Target directory is [" + this.testTarget + "]"));
        this.testClasses = this.findTestClasses();
        if (this.testClasses.isEmpty()) {
            this.log.info((CharSequence)"No test classes found");
        } else {
            this.log.info((CharSequence)("Found [" + this.testClasses.size() + "] test classes"));
        }
    }

    public boolean hasTests() {
        return this.testClasses.size() > 0;
    }

    private List<Class> findTestClasses() throws MalformedURLException, ClassNotFoundException {
        File file = new File(this.testTarget);
        URL url = file.toURI().toURL();
        URL[] urls = new URL[]{url};
        URLClassLoader cl = new URLClassLoader(urls, this.getClass().getClassLoader());
        Collection<File> classFiles = this.listFiles(file);
        ArrayList<Class> testClasses = new ArrayList<Class>();
        for (File classFile : classFiles) {
            String path = classFile.getAbsolutePath();
            this.log.info((CharSequence)("Found [" + path + "]"));
            if (!path.endsWith(".class")) continue;
            String shortName = path.substring(this.testTarget.length() + 1, path.length() - 6);
            Object[] parts = StringUtils.split((String)shortName, (String)File.separator);
            String className = StringUtils.join((Object[])parts, (String)".");
            this.log.info((CharSequence)("Found test class [" + className + "]"));
            Class<?> cls = cl.loadClass(className);
            this.log.info((CharSequence)("Class loaded is [" + cls.getCanonicalName() + "]"));
            if (cls.getAnnotation(SparkITCase.class) != null) {
                this.log.info((CharSequence)("Could not find test annotation on [" + cls.getCanonicalName() + "]"));
                testClasses.add(cls);
                continue;
            }
            this.log.info((CharSequence)("Found test annotation on [" + cls.getCanonicalName() + "]"));
        }
        return testClasses;
    }

    public void distribute() {
    }

    public Collection<File> listFiles(File input) {
        return FileUtils.listFiles((File)input, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return true;
            }

            public boolean accept(File dir, String name) {
                return true;
            }
        }, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File dir, String name) {
                return true;
            }

            public boolean accept(File file) {
                return true;
            }
        });
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setTestTarget(String testTarget) {
        this.testTarget = testTarget;
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    public String getTestTarget() {
        return this.testTarget;
    }

    public List<Class> getTestClasses() {
        return this.testClasses;
    }
}

