/*
 * Decompiled with CFR 0.152.
 */
package solutions.deepfield.spark.itcase.maven;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.mashape.unirest.request.body.RawBody;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import solutions.deepfield.spark.itcase.core.domain.RunParams;
import solutions.deepfield.spark.itcase.core.domain.RunResult;
import solutions.deepfield.spark.itcase.exceptions.SparkITCaseException;

public class SparkRunUtil {
    private String endpoint;
    private Log log;

    public void run(String jobClass, List<String> params1, String artifactId, String groupId, String version) throws JsonProcessingException, UnirestException, IOException {
        RunParams params = new RunParams();
        params.setArtifactId(artifactId);
        params.setGroupId(groupId);
        params.setVersion(version);
        params.setClassName(jobClass);
        params.setParameters(params1);
        ObjectMapper mapper = new ObjectMapper();
        byte[] dataToSend = mapper.writeValueAsBytes((Object)params);
        HttpRequestWithBody requestWithBody = Unirest.post((String)(this.endpoint + "/spark/run"));
        requestWithBody = requestWithBody.header("Content-Type", "application/json");
        requestWithBody = requestWithBody.header("Accept", "application/json");
        RawBody rawBody = requestWithBody.body(dataToSend);
        this.log.info((CharSequence)"About to make request to server");
        HttpResponse response = rawBody.asString();
        this.handleResponse(jobClass, params1, (HttpResponse<String>)response);
    }

    private synchronized void handleResponse(String jobClass, List<String> params1, HttpResponse<String> response) throws IOException, JsonProcessingException {
        RunResult result;
        this.log.info((CharSequence)("Handling response for [" + jobClass + "] with [" + StringUtils.join(params1, (String)",") + "]"));
        ObjectMapper mapper = new ObjectMapper();
        List content = (List)response.getHeaders().get((Object)"Content-Type");
        if (content.size() == 1 && ((String)content.get(0)).toLowerCase().startsWith("application/json") && (result = (RunResult)mapper.readerFor(RunResult.class).readValue((String)response.getBody())).getLogs() != null && result.getLogs().size() > 0) {
            for (String resultLog : result.getLogs()) {
                this.log.info((CharSequence)("Server log: " + resultLog));
            }
        }
        if (response.getStatus() != 200) {
            this.log.info((CharSequence)("Request to run had error [" + response.getStatus() + "]"));
            content = (List)response.getHeaders().get((Object)"Content-Type");
            if (content.size() == 1 && ((String)content.get(0)).toLowerCase().startsWith("application/json")) {
                result = (RunResult)mapper.readerFor(RunResult.class).readValue((String)response.getBody());
                if (result.getLogs() != null && result.getLogs().size() > 0) {
                    for (String resultLog : result.getLogs()) {
                        this.log.error((CharSequence)("Server log: " + resultLog));
                    }
                }
                this.log.error((CharSequence)("Error stack:\n" + result.getExceptionStack()));
                throw new SparkITCaseException("Received error " + result.getExceptionMessage());
            }
            this.log.error((CharSequence)("Unknown error payload content type: " + content));
            throw new SparkITCaseException("Received error " + response.getStatusText());
        }
        this.log.info((CharSequence)"Request to run complete");
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

