/*
 * Decompiled with CFR 0.152.
 */
package solutions.deepfield.spark.itcase.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.GetRequest;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import solutions.deepfield.spark.itcase.core.domain.ApplicationStatusResponse;
import solutions.deepfield.spark.itcase.core.util.AppUtil;
import solutions.deepfield.spark.itcase.exceptions.SparkITCaseException;
import solutions.deepfield.spark.itcase.maven.DeployUtil;
import solutions.deepfield.spark.itcase.maven.SparkRunUtil;

public class BaseSparkITCasePlugin
extends AbstractMojo {
    @Parameter(property="project")
    protected MavenProject project = null;
    @Parameter
    protected String endpoint;
    @Parameter
    protected String proxyHost;
    @Parameter
    protected int proxyPort;
    @Parameter(property="project.build.directory")
    protected File buildDir;
    @Parameter(property="project.basedir")
    protected File projectBase;
    @Parameter(property="project.build.finalName")
    protected String finalName;
    protected DeployUtil deployUtil;
    protected AppUtil appUtil;
    protected SparkRunUtil runUtil;

    protected void init() {
        this.appUtil = new AppUtil();
        this.appUtil.loadProperties();
        this.getLog().info((CharSequence)("Plugin version is [" + this.appUtil.getVersion() + "]"));
        this.getLog().info((CharSequence)("Plugin build is [" + this.appUtil.getTimestamp() + "]"));
        this.deployUtil = new DeployUtil();
        this.deployUtil.setEndpoint(this.endpoint);
        this.deployUtil.setLog(this.getLog());
        this.runUtil = new SparkRunUtil();
        this.runUtil.setEndpoint(this.endpoint);
        this.runUtil.setLog(this.getLog());
    }

    public void preExecute() throws Exception {
    }

    public void postExecute() throws Exception {
    }

    public void execute() throws MojoExecutionException {
        try {
            this.preExecute();
            if (StringUtils.isNotBlank((String)this.proxyHost)) {
                Unirest.setProxy((HttpHost)new HttpHost(this.proxyHost, this.proxyPort));
            }
            this.init();
            this.checkStatus();
            File jar = new File(this.buildDir.getAbsolutePath() + File.separator + this.finalName + ".jar");
            String artifactId = this.project.getArtifactId();
            String groupId = this.project.getGroupId();
            String version = this.project.getVersion();
            File pom = new File(this.projectBase.getAbsoluteFile() + File.separator + "pom.xml");
            this.deployUtil.deploy(jar, groupId, artifactId, version, pom);
            List dependencies = this.project.getDependencies();
            for (Dependency dependency : dependencies) {
                if (dependency.getScope().equalsIgnoreCase("provided") || dependency.getScope().equalsIgnoreCase("test")) {
                    this.getLog().info((CharSequence)("Skipping [" + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + "]"));
                    continue;
                }
                this.getLog().info((CharSequence)("Found dependency [" + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + "]"));
                HashMap<String, String> parameters2 = new HashMap<String, String>();
                parameters2.put("artifactId", dependency.getArtifactId());
                parameters2.put("groupId", dependency.getGroupId());
                parameters2.put("version", dependency.getVersion());
                HttpResponse resultDep = Unirest.get((String)(this.endpoint + "/artifact/retrieve")).queryString(parameters2).asString();
                this.getLog().info((CharSequence)("Found http response:\n" + (String)resultDep.getBody()));
            }
            this.postExecute();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Error invoking spark itcase server at [" + this.endpoint + "]:" + e.getMessage(), e);
        }
    }

    protected void checkStatus() throws Exception {
        ApplicationStatusResponse status;
        GetRequest request = Unirest.get((String)(this.endpoint + "/status"));
        request = request.header("Content-Type", "application/json");
        HttpResponse response = (request = request.header("Accept", "application/json")).asString();
        if (response.getStatus() == 200) {
            ObjectMapper mapper = new ObjectMapper();
            status = (ApplicationStatusResponse)mapper.readerFor(ApplicationStatusResponse.class).readValue((String)response.getBody());
            if (!status.getVersion().equals(this.appUtil.getVersion())) {
                throw new SparkITCaseException("Server version [" + status.getVersion() + "] does not match client [" + this.appUtil.getVersion() + "]");
            }
            this.getLog().info((CharSequence)("Matched client-server version [" + status.getVersion() + "]"));
        } else {
            throw new SparkITCaseException("Unable to retrieve status, received [" + response.getStatus() + "], message [" + response.getStatusText() + "]");
        }
        this.getLog().info((CharSequence)("Server running as user [" + status.getUser() + "]"));
        this.getLog().info((CharSequence)("Server uptime [" + status.getUptime() + "]"));
    }
}

