/*
 * Decompiled with CFR 0.152.
 */
package solutions.deepfield.spark.itcase.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.mashape.unirest.request.body.MultipartBody;
import com.mashape.unirest.request.body.RawBody;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import solutions.deepfield.spark.itcase.maven.RunParams;

@Mojo(name="sparkItCase", defaultPhase=LifecyclePhase.INTEGRATION_TEST)
public class SparkITCaseMavenPlugin
extends AbstractMojo {
    @Parameter(property="project")
    private MavenProject project = null;
    @Parameter
    private String endpoint;
    @Parameter
    private String proxyHost;
    @Parameter
    private int proxyPort;
    @Parameter(property="project.build.directory")
    private File buildDir;
    @Parameter(property="project.basedir")
    private File projectBase;
    @Parameter(property="project.build.finalName")
    private String finalName;
    @Parameter
    private String classToRun;

    public void execute() throws MojoExecutionException {
        try {
            if (StringUtils.isNotBlank((String)this.proxyHost)) {
                Unirest.setProxy((HttpHost)new HttpHost(this.proxyHost, this.proxyPort));
            }
            this.getLog().info((CharSequence)"Deploying project artifact");
            HttpRequestWithBody body = Unirest.post((String)(this.endpoint + "/artifact/deploy"));
            MultipartBody multiPartBody = body.field("artifact", new File(this.buildDir.getAbsolutePath() + File.separator + this.finalName + ".jar"));
            multiPartBody.field("artifactId", this.project.getArtifactId());
            multiPartBody.field("groupId", this.project.getGroupId());
            multiPartBody.field("version", this.project.getVersion());
            File pomFile = new File(this.projectBase.getAbsoluteFile() + File.separator + "pom.xml");
            multiPartBody = multiPartBody.field("pom", pomFile);
            this.getLog().info((CharSequence)("Found http response:\n" + (String)multiPartBody.asString().getBody()));
            this.getLog().info((CharSequence)("Looking for build artifact [" + this.buildDir.getAbsolutePath() + "]"));
            List dependencies = this.project.getDependencies();
            for (Dependency dependency : dependencies) {
                if (dependency.getScope().equalsIgnoreCase("provided")) {
                    this.getLog().info((CharSequence)("Skipping [" + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + "]"));
                    continue;
                }
                this.getLog().info((CharSequence)("Found dependency [" + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + "]"));
                HashMap<String, String> parameters2 = new HashMap<String, String>();
                parameters2.put("artifactId", dependency.getArtifactId());
                parameters2.put("groupId", dependency.getGroupId());
                parameters2.put("version", dependency.getVersion());
                HttpResponse resultDep = Unirest.get((String)(this.endpoint + "/artifact/retrieve")).queryString(parameters2).asString();
                this.getLog().info((CharSequence)("Found http response:\n" + (String)resultDep.getBody()));
            }
            RunParams params = new RunParams();
            params.setArtifactId(this.project.getArtifactId());
            params.setGroupId(this.project.getGroupId());
            params.setVersion(this.project.getVersion());
            params.setClassName(this.classToRun);
            ObjectMapper mapper = new ObjectMapper();
            byte[] dataToSend = mapper.writeValueAsBytes((Object)params);
            HttpRequestWithBody requestWithBody = Unirest.post((String)(this.endpoint + "/spark/run"));
            requestWithBody = requestWithBody.header("Content-Type", "application/json");
            requestWithBody = requestWithBody.header("Accept", "application/json");
            RawBody rawBody = requestWithBody.body(dataToSend);
            this.getLog().info((CharSequence)"About to make request to server");
            HttpResponse response = rawBody.asString();
            this.getLog().info((CharSequence)("Request to run complete: " + (String)response.getBody()));
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Unable to check version on test server for endpoint [" + this.endpoint + "]:" + e.getMessage(), e);
        }
    }
}

