/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.maps.leaflet.registry;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.xdev.vaadin.maps.leaflet.base.LComponent;
import software.xdev.vaadin.maps.leaflet.base.LComponentOptions;
import software.xdev.vaadin.maps.leaflet.base.RawString;
import software.xdev.vaadin.maps.leaflet.registry.LComponentManagementRegistry;

public class LDefaultComponentManagementRegistry
extends Composite<Div>
implements LComponentManagementRegistry {
    protected static final AtomicLong NEXT_ID = new AtomicLong(1L);
    protected Map<LComponent<?>, Integer> componentIndexMap = new WeakHashMap();
    protected AtomicInteger nextComponentId = new AtomicInteger(1);
    protected AtomicInteger clientMapSize = new AtomicInteger(0);
    protected final ObjectWriter optionsWriter;

    public LDefaultComponentManagementRegistry(HasComponents parent) {
        this(parent, LDefaultComponentManagementRegistry.getDefaultWriterForOptions());
    }

    public LDefaultComponentManagementRegistry(HasComponents parent, ObjectWriter optionsWriter) {
        this.optionsWriter = Objects.requireNonNull(optionsWriter);
        this.setId("lComponentRegistry" + NEXT_ID.getAndIncrement());
        this.getElement().executeJs(this.clientComponents() + " = new Map();", new Serializable[0]);
        ((Div)this.getContent()).getElement().setAttribute("hidden", true);
        parent.add(new Component[]{this});
    }

    @Override
    public String writeOptionsOptionalNextParameter(LComponentOptions<?> options) {
        return options == null ? "" : ", " + this.writeOptionsOrEmptyObject(options);
    }

    @Override
    public String writeOptions(LComponentOptions<?> options) {
        return this.writeOptions(options, "");
    }

    @Override
    public String writeOptionsOrEmptyObject(LComponentOptions<?> options) {
        return this.writeOptions(options, "{}");
    }

    protected String writeOptions(Object options, String nullDefault) {
        if (options == null) {
            return nullDefault;
        }
        try {
            return this.optionsWriter.writeValueAsString(options);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String clientComponents() {
        return "document.getElementById('" + (String)this.getId().orElseThrow() + "').lComponents";
    }

    @Override
    public <C extends LComponent<C>> C add(C component, String jsConstructorCallExpression, Serializable ... parameters) {
        int currentId = this.nextComponentId.getAndIncrement();
        this.getElement().executeJs(this.clientComponents() + ".set(" + currentId + ", " + jsConstructorCallExpression + ");", parameters);
        this.clientMapSize.incrementAndGet();
        this.componentIndexMap.put(component, currentId);
        return component;
    }

    @Override
    public String clientComponentJsAccessor(LComponent<?> component) {
        return Optional.ofNullable(this.componentIndexMap.get(component)).map(id -> this.clientComponents() + ".get(" + id + ")").orElse(null);
    }

    @Override
    public PendingJavaScriptResult execJs(String js, Serializable ... params) {
        return this.getElement().executeJs(js, params);
    }

    @Override
    public <C extends LComponent<C>> void remove(C component, boolean freeUpClientWhenNoMatch) {
        Integer removedId = this.componentIndexMap.remove(component);
        if (removedId != null) {
            this.getElement().executeJs(this.clientComponents() + ".delete(" + removedId + ");", new Serializable[0]);
            this.clientMapSize.decrementAndGet();
            return;
        }
        if (freeUpClientWhenNoMatch) {
            this.freeUpClient();
        }
    }

    @Override
    public void freeUpClient() {
        if (this.clientMapSize.get() != this.componentIndexMap.size()) {
            Collection<Integer> ids = this.componentIndexMap.values();
            this.getElement().executeJs("let activeIds = [%s];\nlet components = %s;\nArray.from(components.keys()).filter(i => !activeIds.includes(i)).forEach(i => components.delete(i));\n".formatted(ids.stream().map(String::valueOf).collect(Collectors.joining(",")), this.clientComponents()), new Serializable[0]);
            this.clientMapSize.set(ids.size());
        }
    }

    @Override
    public void clearAll() {
        this.getElement().executeJs(this.clientComponents() + ".clear();", new Serializable[0]);
        this.clientMapSize.set(0);
    }

    protected static ObjectWriter getDefaultWriterForOptions() {
        return new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.NON_EMPTY).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.CREATOR, JsonAutoDetect.Visibility.NONE).registerModule((Module)new SimpleModule().addSerializer(RawString.class, new RawSerializer<RawString>(RawString::getValue)).addSerializer(LComponent.class, new RawSerializer<LComponent>(LComponent::clientComponentJsAccessor))).writer();
    }

    protected static class RawSerializer<V>
    extends StdSerializer<V> {
        private final Function<V, String> rawValueExtractor;

        public RawSerializer(Function<V, String> rawValueExtractor) {
            super((Class)null);
            this.rawValueExtractor = Objects.requireNonNull(rawValueExtractor);
        }

        public void serialize(V value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeRawValue(this.rawValueExtractor.apply(value));
        }
    }
}

