/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.maps.leaflet.map;

import com.vaadin.flow.component.html.Div;
import java.io.Serializable;
import java.util.UUID;
import software.xdev.vaadin.maps.leaflet.base.LBaseComponent;
import software.xdev.vaadin.maps.leaflet.base.LEvented;
import software.xdev.vaadin.maps.leaflet.basictypes.LLatLng;
import software.xdev.vaadin.maps.leaflet.basictypes.LLatLngBounds;
import software.xdev.vaadin.maps.leaflet.basictypes.LPoint;
import software.xdev.vaadin.maps.leaflet.controls.LControl;
import software.xdev.vaadin.maps.leaflet.layer.LLayer;
import software.xdev.vaadin.maps.leaflet.layer.ui.LPopup;
import software.xdev.vaadin.maps.leaflet.layer.ui.LTooltip;
import software.xdev.vaadin.maps.leaflet.map.LMapFitBoundOptions;
import software.xdev.vaadin.maps.leaflet.map.LMapLocateOptions;
import software.xdev.vaadin.maps.leaflet.map.LMapOptions;
import software.xdev.vaadin.maps.leaflet.map.LMapPanOptions;
import software.xdev.vaadin.maps.leaflet.map.LMapZoomOptions;
import software.xdev.vaadin.maps.leaflet.map.LMapZoomPanOptions;
import software.xdev.vaadin.maps.leaflet.registry.LComponentManagementRegistry;

public class LMap
extends LBaseComponent<LMap>
implements LEvented<LMap> {
    public LMap(LComponentManagementRegistry compReg, String id) {
        this(compReg, id, (LMapOptions)null);
    }

    public LMap(LComponentManagementRegistry compReg, String id, LMapOptions options) {
        super(compReg, "L.map($0" + compReg.writeOptionsOptionalNextParameter(options) + ")", new Serializable[]{id});
    }

    public LMap(LComponentManagementRegistry compReg, Div bindDiv) {
        this(compReg, bindDiv, null);
    }

    public LMap(LComponentManagementRegistry compReg, Div bindDiv, LMapOptions options) {
        this(compReg, bindDiv.getId().orElseGet(() -> {
            String dynamicId = "map-dynId-" + UUID.randomUUID();
            bindDiv.setId(dynamicId);
            return dynamicId;
        }), options);
    }

    public static void fixZIndex(Div div) {
        div.getStyle().set("z-index", "1");
    }

    public void fixInvalidSizeAfterCreation(String callback) {
        this.componentRegistry().execJs("let tempMap = " + this.clientComponentJsAccessor() + "; setTimeout(function () {   tempMap.invalidateSize(false); " + (callback != null ? callback : "") + " }, 100)", new Serializable[0]);
    }

    public LMap addControl(LControl<?> control) {
        this.invokeSelf(".addControl(" + control.clientComponentJsAccessor() + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap removeControl(LControl<?> control) {
        this.invokeSelf(".removeControl(" + control.clientComponentJsAccessor() + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap addLayer(LLayer<?> layer) {
        this.invokeSelf(".addLayer(" + layer.clientComponentJsAccessor() + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap removeLayer(LLayer<?> layer) {
        this.invokeSelf(".removeLayer(" + layer.clientComponentJsAccessor() + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap openPopup(LPopup popup) {
        this.invokeSelf(".openPopup(" + popup.clientComponentJsAccessor() + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap closePopup(LPopup popup) {
        this.invokeSelf(".closePopup(" + popup.clientComponentJsAccessor() + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap closePopup() {
        this.invokeSelf(".closePopup()", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap openTooltip(LTooltip tooltip) {
        this.invokeSelf(".openTooltip(" + tooltip.clientComponentJsAccessor() + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap closeTooltip(LTooltip tooltip) {
        this.invokeSelf(".closeTooltip(" + tooltip.clientComponentJsAccessor() + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap closeTooltip() {
        this.invokeSelf(".closeTooltip()", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap setView(LLatLng center, int zoom, LMapZoomPanOptions options) {
        this.invokeSelf(".setView(" + center.clientComponentJsAccessor() + "," + zoom + this.componentRegistry().writeOptionsOptionalNextParameter(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap setView(LLatLng center, int zoom) {
        return this.setView(center, zoom, null);
    }

    public LMap zoomIn(Integer delta, LMapZoomOptions options) {
        this.invokeSelf(".zoomIn(" + (Serializable)(delta != null ? delta : "") + this.componentRegistry().writeOptionsOptionalNextParameter(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap zoomIn(Integer delta) {
        return this.zoomIn(delta, null);
    }

    public LMap zoomIn() {
        return this.zoomIn(null);
    }

    public LMap zoomOut(Integer delta, LMapZoomOptions options) {
        this.invokeSelf(".zoomOut(" + (Serializable)(delta != null ? delta : "") + this.componentRegistry().writeOptionsOptionalNextParameter(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap zoomOut(Integer delta) {
        return this.zoomOut(delta, null);
    }

    public LMap zoomOut() {
        return this.zoomOut(null);
    }

    public LMap setZoomAround(LLatLng latLng, int zoom, LMapZoomOptions options) {
        this.invokeSelf(".setZoomAround(" + latLng.clientComponentJsAccessor() + ",$0" + this.componentRegistry().writeOptionsOptionalNextParameter(options) + ")", Integer.valueOf(zoom));
        return (LMap)this.self();
    }

    public LMap setZoomAround(LLatLng latLng, int zoom) {
        return this.setZoomAround(latLng, zoom, null);
    }

    public LMap setZoomAround(LPoint point, int zoom, LMapZoomOptions options) {
        this.invokeSelf(".setZoomAround(" + point.clientComponentJsAccessor() + ",$0" + this.componentRegistry().writeOptionsOptionalNextParameter(options) + ")", Integer.valueOf(zoom));
        return (LMap)this.self();
    }

    public LMap setZoomAround(LPoint point, int zoom) {
        return this.setZoomAround(point, zoom, null);
    }

    public LMap fitBounds(LLatLngBounds bounds, LMapFitBoundOptions options) {
        this.invokeSelf(".fitBounds(" + bounds.clientComponentJsAccessor() + this.componentRegistry().writeOptionsOptionalNextParameter(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap fitBounds(LLatLngBounds bounds) {
        return this.fitBounds(bounds, null);
    }

    public LMap fitWorld(LMapFitBoundOptions options) {
        this.invokeSelf(".fitWorld(" + this.componentRegistry().writeOptions(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap fitWorld() {
        return this.fitWorld(null);
    }

    public LMap panTo(LLatLng latLng, LMapPanOptions options) {
        this.invokeSelf(".panTo(" + latLng.clientComponentJsAccessor() + this.componentRegistry().writeOptions(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap panTo(LLatLng latLng) {
        return this.panTo(latLng, null);
    }

    public LMap panBy(LPoint offset, LMapPanOptions options) {
        this.invokeSelf(".panBy(" + offset.clientComponentJsAccessor() + this.componentRegistry().writeOptions(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap panBy(LPoint offset) {
        return this.panBy(offset, null);
    }

    public LMap flyTo(LLatLng latLng, Integer zoom, LMapZoomPanOptions options) {
        this.invokeSelf(".flyTo(" + latLng.clientComponentJsAccessor() + (String)(zoom != null ? "," + zoom : "") + this.componentRegistry().writeOptionsOptionalNextParameter(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap flyTo(LLatLng latLng, Integer zoom) {
        return this.flyTo(latLng, zoom, null);
    }

    public LMap flyTo(LLatLng latLng) {
        return this.flyTo(latLng, null);
    }

    public LMap flyToBounds(LLatLngBounds bounds, LMapZoomPanOptions options) {
        this.invokeSelf(".flyToBounds(" + bounds.clientComponentJsAccessor() + this.componentRegistry().writeOptionsOptionalNextParameter(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap flyToBounds(LLatLngBounds bounds) {
        return this.flyToBounds(bounds, null);
    }

    public LMap setMaxBounds(LLatLngBounds bounds) {
        this.invokeSelf(".setMaxBounds(" + bounds.clientComponentJsAccessor() + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap setMinZoom(int zoom) {
        this.invokeSelf(".setMinZoom($0)", Integer.valueOf(zoom));
        return (LMap)this.self();
    }

    public LMap setMaxZoom(int zoom) {
        this.invokeSelf(".setMaxZoom($0)", Integer.valueOf(zoom));
        return (LMap)this.self();
    }

    public LMap panInsideBounds(LLatLngBounds bounds, LMapPanOptions options) {
        this.invokeSelf(".panInsideBounds(" + bounds.clientComponentJsAccessor() + this.componentRegistry().writeOptionsOptionalNextParameter(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap panInsideBounds(LLatLngBounds bounds) {
        return this.panInsideBounds(bounds, null);
    }

    public LMap panInside(LLatLng latLng, LMapPanOptions options) {
        this.invokeSelf(".panInside(" + latLng.clientComponentJsAccessor() + this.componentRegistry().writeOptionsOptionalNextParameter(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap panInside(LLatLng latLng) {
        return this.panInside(latLng, null);
    }

    public LMap invalidateSize(LMapZoomPanOptions options) {
        this.invokeSelf(".invalidateSize(" + this.componentRegistry().writeOptions(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap invalidateSize(boolean animate) {
        this.invokeSelf(".invalidateSize($0)", Boolean.valueOf(animate));
        return (LMap)this.self();
    }

    public LMap stop() {
        this.invokeSelf(".stop()", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap locate(LMapLocateOptions options) {
        this.invokeSelf(".locate(" + this.componentRegistry().writeOptions(options) + ")", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap locate() {
        return this.locate(null);
    }

    public LMap stopLocate() {
        this.invokeSelf(".stopLocate()", new Serializable[0]);
        return (LMap)this.self();
    }

    public LMap remove() {
        this.invokeSelf(".remove()", new Serializable[0]);
        return (LMap)this.self();
    }
}

