/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.maps.leaflet.controls;

import java.io.Serializable;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import software.xdev.vaadin.maps.leaflet.controls.LControl;
import software.xdev.vaadin.maps.leaflet.controls.LControlLayersOptions;
import software.xdev.vaadin.maps.leaflet.layer.LLayer;
import software.xdev.vaadin.maps.leaflet.registry.LComponentManagementRegistry;

public class LControlLayers
extends LControl<LControlLayers> {
    public LControlLayers(LComponentManagementRegistry compReg, Map<String, LLayer<?>> baselayers, Map<String, LLayer<?>> overlays, LControlLayersOptions options) {
        super(compReg, "L.control.layers(" + (baselayers != null ? LControlLayers.convertLayerMapToString(baselayers) : "{}") + "," + (overlays != null ? LControlLayers.convertLayerMapToString(overlays) : "{}") + compReg.writeOptionsOptionalNextParameter(options) + ")", new Serializable[0]);
    }

    public LControlLayers(LComponentManagementRegistry compReg, Map<String, LLayer<?>> baselayers, Map<String, LLayer<?>> overlays) {
        this(compReg, baselayers, overlays, null);
    }

    public LControlLayers(LComponentManagementRegistry compReg, Map<String, LLayer<?>> baselayers, LControlLayersOptions options) {
        this(compReg, baselayers, null, options);
    }

    public LControlLayers(LComponentManagementRegistry compReg, Map<String, LLayer<?>> baselayers) {
        this(compReg, baselayers, (LControlLayersOptions)null);
    }

    public LControlLayers(LComponentManagementRegistry compReg) {
        this(compReg, null);
    }

    protected static String convertLayerMapToString(Map<String, LLayer<?>> map) {
        return "{" + map.entrySet().stream().map(e -> "\"" + StringEscapeUtils.escapeEcmaScript((String)((String)e.getKey())) + "\":" + ((LLayer)e.getValue()).clientComponentJsAccessor()).collect(Collectors.joining(",")) + "}";
    }

    public LControlLayers addBaseLayer(LLayer<?> layer, String name) {
        this.invokeSelf(".addBaseLayer(" + layer.clientComponentJsAccessor() + ",$0)", new Serializable[]{name});
        return (LControlLayers)this.self();
    }

    public LControlLayers addOverlay(LLayer<?> layer, String name) {
        this.invokeSelf(".addOverlay(" + layer.clientComponentJsAccessor() + ",$0)", new Serializable[]{name});
        return (LControlLayers)this.self();
    }

    public LControlLayers removeLayer(LLayer<?> layer) {
        this.invokeSelf(".removeLayer(" + layer.clientComponentJsAccessor() + ")", new Serializable[0]);
        return (LControlLayers)this.self();
    }

    public LControlLayers expand() {
        this.invokeSelf(".expand()", new Serializable[0]);
        return (LControlLayers)this.self();
    }

    public LControlLayers collapse() {
        this.invokeSelf(".collapse()", new Serializable[0]);
        return (LControlLayers)this.self();
    }
}

