/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.editable_label.predefined;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.dataview.ComboBoxDataView;
import com.vaadin.flow.component.combobox.dataview.ComboBoxLazyDataView;
import com.vaadin.flow.component.combobox.dataview.ComboBoxListDataView;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasLazyDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.Consumer;
import software.xdev.vaadin.editable_label.AbstractEditableLabel;

public class EditableLabelComboBox<T>
extends AbstractEditableLabel<EditableLabelComboBox<T>, ComboBox<T>, T>
implements HasDataView<T, String, ComboBoxDataView<T>>,
HasListDataView<T, ComboBoxListDataView<T>>,
HasLazyDataView<T, String, ComboBoxLazyDataView<T>> {
    public EditableLabelComboBox() {
        this(new ComboBox());
    }

    public EditableLabelComboBox(ComboBox<T> editor) {
        this(editor, (Consumer<EditableLabelComboBox<T>>)null);
    }

    public EditableLabelComboBox(Consumer<EditableLabelComboBox<T>> additionalInitActions) {
        this(new ComboBox(), additionalInitActions);
    }

    public EditableLabelComboBox(ComboBox<T> editor, Consumer<EditableLabelComboBox<T>> additionalInitActions) {
        super(editor, additionalInitActions);
    }

    @Override
    protected void initUI() {
        super.initUI();
        this.addEditModeChangedListener((ComponentEventListener & Serializable)ev -> ((ComboBox)this.getEditor()).setOpened(ev.isEditModeEnabled()));
    }

    @Override
    public EditableLabelComboBox<T> withNativeLabelGenerator(ItemLabelGenerator<T> labelGenerator) {
        super.withNativeLabelGenerator(labelGenerator);
        ((ComboBox)this.getEditor()).setItemLabelGenerator(labelGenerator);
        return (EditableLabelComboBox)((Object)this.self());
    }

    public EditableLabelComboBox<T> withItems(T ... items) {
        return this.withItems(DataProvider.ofItems((Object[])items));
    }

    public EditableLabelComboBox<T> withItems(Collection<T> items) {
        return this.withItems(DataProvider.ofCollection(items));
    }

    public EditableLabelComboBox<T> withItems(ListDataProvider<T> items) {
        this.setItems(items);
        return (EditableLabelComboBox)((Object)this.self());
    }

    public ComboBoxListDataView<T> setItems(ListDataProvider<T> dataProvider) {
        return ((ComboBox)this.getEditor()).setItems(dataProvider);
    }

    public ComboBoxListDataView<T> getListDataView() {
        return ((ComboBox)this.getEditor()).getListDataView();
    }

    public ComboBoxDataView<T> setItems(DataProvider<T, String> dataProvider) {
        return ((ComboBox)this.getEditor()).setItems(dataProvider);
    }

    @Deprecated(forRemoval=true)
    public ComboBoxDataView<T> setItems(InMemoryDataProvider<T> dataProvider) {
        return ((ComboBox)this.getEditor()).setItems(dataProvider);
    }

    public ComboBoxDataView<T> getGenericDataView() {
        return ((ComboBox)this.getEditor()).getGenericDataView();
    }

    public ComboBoxLazyDataView<T> setItems(BackEndDataProvider<T, String> dataProvider) {
        return ((ComboBox)this.getEditor()).setItems(dataProvider);
    }

    public ComboBoxLazyDataView<T> getLazyDataView() {
        return ((ComboBox)this.getEditor()).getLazyDataView();
    }
}

