/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.editable_label;

import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

@CssImport(value="./styles/editableLabel.css")
public abstract class AbstractEditableLabel<S extends AbstractEditableLabel<S, C, V>, C extends Component & HasStyle, V>
extends AbstractCompositeField<Div, S, V>
implements HasStyle,
HasSize {
    protected final Button btnEdit = new Button((Component)VaadinIcon.PENCIL.create());
    protected final Button btnSave = new Button((Component)VaadinIcon.CHECK.create());
    protected final Button btnClose = new Button((Component)VaadinIcon.CLOSE.create());
    protected final Span label = new Span();
    protected final C editor;
    protected ItemLabelGenerator<V> nativeLabelGenerator;
    protected String emptyLabelValue = "";

    protected AbstractEditableLabel(C editor, Consumer<S> additionalInitActions) {
        super(((HasValue)editor).getEmptyValue());
        this.editor = editor;
        this.initUI();
        this.registerListeners();
        if (additionalInitActions != null) {
            additionalInitActions.accept(this.self());
        }
        this.disableEditMode();
        this.withLabelGenerator(Object::toString);
    }

    protected void initUI() {
        this.addClassName("editable-label-container");
        this.label.addClassName("editable-label-label");
        this.btnEdit.addClassName("editable-label-edit-button");
        this.btnSave.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        this.btnClose.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        Stream.of(this.btnEdit, this.btnSave, this.btnClose).forEach(btn -> {
            btn.addClassName("editable-label-button");
            btn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_TERTIARY});
        });
        this.getEditor().addClassName("editable-label-editor");
        ((HasSize)this.getEditor()).setWidthFull();
        ((Div)this.getContent()).add(new Component[]{this.label, this.editor, this.btnEdit, this.btnSave, this.btnClose});
    }

    protected void registerListeners() {
        this.btnEdit.addClickListener(this::onEdit);
        this.btnSave.addClickListener(this::onSave);
        this.btnClose.addClickListener(this::onClose);
    }

    protected void onEdit(ClickEvent<Button> ev) {
        ((HasValue)this.getEditor()).setValue(this.getValue());
        this.enableEditMode(ev.isFromClient());
    }

    protected void onSave(ClickEvent<Button> ev) {
        this.updateValue(((HasValue)this.getEditor()).getValue(), ev.isFromClient());
        this.disableEditMode(ev.isFromClient());
    }

    protected void onClose(ClickEvent<Button> ev) {
        this.disableEditMode(ev.isFromClient());
    }

    public S withValue(V value) {
        this.setValue(value);
        return this.self();
    }

    protected void updateValue(V newValue, boolean isFromClient) {
        Object oldValue = this.getValue();
        this.setModelValue(newValue, isFromClient);
        if (!this.valueEquals(oldValue, newValue)) {
            this.setPresentationValue(newValue);
        }
    }

    protected void setPresentationValue(V newPresentationValue) {
        this.updateLabelText(newPresentationValue);
    }

    protected void updateLabelText(V value) {
        String labelText = this.nativeLabelGenerator.apply(value);
        this.btnEdit.setClassName("editable-label-edit-button-always-visible", labelText == null || labelText.isBlank());
        this.label.setText(labelText);
    }

    public void enableEditMode() {
        this.enableEditMode(false);
    }

    protected void enableEditMode(boolean isFromClient) {
        this.setEditMode(true, isFromClient);
    }

    public void disableEditMode() {
        this.disableEditMode(false);
    }

    protected void disableEditMode(boolean isFromClient) {
        this.setEditMode(false, isFromClient);
    }

    public void setEditMode(boolean enabled) {
        this.setEditMode(enabled, false);
    }

    protected void setEditMode(boolean enabled, boolean isFromClient) {
        if (this.isEditMode() == enabled || this.isReadOnly() && enabled) {
            return;
        }
        this.getEditor().setVisible(enabled);
        this.label.setVisible(!enabled);
        this.btnEdit.setVisible(!enabled);
        this.btnSave.setVisible(enabled);
        this.btnClose.setVisible(enabled);
        if (enabled && this.getEditor() instanceof Focusable) {
            ((Focusable)this.getEditor()).focus();
        }
        this.fireEvent(new EditModeChangedEvent(enabled, this.self(), isFromClient));
    }

    public boolean isEditMode() {
        return this.getEditor().isVisible();
    }

    public Registration addEditModeChangedListener(ComponentEventListener<EditModeChangedEvent<S, C, V>> listener) {
        return this.addListener(EditModeChangedEvent.class, listener);
    }

    public S withEditIcon(Component editIcon) {
        this.btnEdit.setIcon(editIcon);
        return this.self();
    }

    public S withSaveIcon(Component saveIcon) {
        this.btnSave.setIcon(saveIcon);
        return this.self();
    }

    public S withCloseIcon(Component closeIcon) {
        this.btnClose.setIcon(closeIcon);
        return this.self();
    }

    public S withNativeLabelGenerator(ItemLabelGenerator<V> labelGenerator) {
        this.nativeLabelGenerator = Objects.requireNonNull(labelGenerator);
        this.updateLabelText(this.getValue());
        return this.self();
    }

    public S withLabelGenerator(ItemLabelGenerator<V> notEmptyLabelGenerator, Supplier<String> emptyValue) {
        return this.withNativeLabelGenerator((ItemLabelGenerator & Serializable)v -> v == null || this.valueEquals(v, this.getEmptyValue()) ? (String)emptyValue.get() : notEmptyLabelGenerator.apply(v));
    }

    public S withLabelGenerator(ItemLabelGenerator<V> notEmptyLabelGenerator, String emptyValue) {
        Objects.requireNonNull(emptyValue);
        return this.withLabelGenerator(notEmptyLabelGenerator, () -> emptyValue);
    }

    public S withLabelGenerator(ItemLabelGenerator<V> notEmptyLabelGenerator) {
        return this.withLabelGenerator(notEmptyLabelGenerator, this.getEmptyLabelValue());
    }

    public String getEmptyLabelValue() {
        return this.emptyLabelValue;
    }

    public S withEmptyLabelValue(String emptyLabelValue) {
        this.emptyLabelValue = Objects.requireNonNull(emptyLabelValue);
        return this.self();
    }

    public C getEditor() {
        return this.editor;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.btnEdit.setEnabled(!readOnly);
        if (readOnly && this.isEditMode()) {
            this.disableEditMode();
        }
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        ((HasValue)this.getEditor()).setRequiredIndicatorVisible(requiredIndicatorVisible);
    }

    protected S self() {
        return (S)((Object)this);
    }

    protected static class EditModeChangedEvent<S extends AbstractEditableLabel<S, C, V>, C extends Component & HasStyle, V>
    extends ComponentEvent<S> {
        protected final boolean editModeEnabled;

        public EditModeChangedEvent(boolean editModeEnabled, S source, boolean fromClient) {
            super(source, fromClient);
            this.editModeEnabled = editModeEnabled;
        }

        public boolean isEditModeEnabled() {
            return this.editModeEnabled;
        }
    }
}

