/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.chips;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.shared.Registration;

public class ChipComponent<T>
extends Composite<HorizontalLayout>
implements HasStyle,
HasSize {
    protected T item;
    protected ItemLabelGenerator<T> itemLabelGenerator = Object::toString;
    protected final Button btnDelete = new Button((Component)VaadinIcon.CLOSE_CIRCLE.create());
    protected final Span label = new Span();

    public ChipComponent(T item) {
        this.item = item;
        this.initUI();
    }

    protected void initUI() {
        this.label.getStyle().set("font-size", "var(--lumo-font-size-s)");
        this.btnDelete.setDisableOnClick(true);
        this.btnDelete.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_TERTIARY_INLINE});
        this.btnDelete.getStyle().set("font-size", "var(--lumo-font-size-m)");
        this.label.setSizeUndefined();
        this.btnDelete.setSizeUndefined();
        ((HorizontalLayout)this.getContent()).setSpacing(false);
        ((HorizontalLayout)this.getContent()).setAlignItems(FlexComponent.Alignment.CENTER);
        Style style = ((HorizontalLayout)this.getContent()).getStyle();
        style.set("background-color", "var(--lumo-contrast-10pct)");
        style.set("border-radius", "var(--lumo-font-size-s)");
        style.set("margin", "var(--lumo-space-xs)");
        style.set("padding-left", " var(--lumo-space-s)");
        ((HorizontalLayout)this.getContent()).add(new Component[]{this.label, this.btnDelete});
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.updateTextFromItemLabelGenerator();
    }

    public T getItem() {
        return this.item;
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        this.itemLabelGenerator = itemLabelGenerator;
    }

    public void updateTextFromItemLabelGenerator() {
        this.label.setText(this.itemLabelGenerator.apply(this.item));
    }

    public Registration addBtnDeleteClickListener(ComponentEventListener<ClickEvent<Button>> listener) {
        return this.btnDelete.addClickListener(listener);
    }

    public void setReadonly(boolean readOnly) {
        this.btnDelete.setEnabled(!readOnly);
    }
}

