/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.chips;

import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.binder.HasItems;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import software.xdev.vaadin.chips.ChipComponent;

public class ChipComboBox<T>
extends AbstractCompositeField<VerticalLayout, ChipComboBox<T>, Set<T>>
implements HasStyle,
Focusable<ChipComboBox<T>>,
HasSize,
HasValidation,
HasTheme,
HasLabel,
HasTooltip,
HasItems<T>,
HasValidator<T> {
    protected ComboBox<T> cbAvailableItems = new ComboBox();
    protected Button btnClearAll = new Button((Component)VaadinIcon.TRASH.create());
    protected HorizontalLayout comboBoxContainer = new HorizontalLayout();
    protected FlexLayout chipsContainer = new FlexLayout();
    protected SerializableFunction<T, ChipComponent<T>> chipsSupplier = ChipComponent::new;
    protected ItemLabelGenerator<T> chipItemLabelGenerator = Object::toString;
    protected final List<T> allAvailableItems = new ArrayList<T>();
    protected final List<ChipComponent<T>> selectedComponents = new ArrayList<ChipComponent<T>>();

    public ChipComboBox() {
        this(new HashSet());
    }

    public ChipComboBox(Set<T> defaultValue) {
        super(defaultValue);
        this.initUI();
        this.initListeners();
    }

    public ChipComboBox(String label) {
        this();
        this.withLabel(label);
    }

    public ChipComboBox(String label, Set<T> defaultValue) {
        this(defaultValue);
        this.withLabel(label);
    }

    protected void initUI() {
        Style chipsContainerStyle = this.chipsContainer.getStyle();
        chipsContainerStyle.set("flex-flow", "wrap");
        chipsContainerStyle.set("flex-direction", "row");
        this.btnClearAll.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_TERTIARY_INLINE});
        this.comboBoxContainer.setAlignItems(FlexComponent.Alignment.BASELINE);
        this.comboBoxContainer.setWidthFull();
        this.comboBoxContainer.add(new Component[]{this.cbAvailableItems, this.btnClearAll});
        ((VerticalLayout)this.getContent()).setPadding(false);
        ((VerticalLayout)this.getContent()).setSpacing(false);
        this.setSizeUndefined();
        ((VerticalLayout)this.getContent()).add(new Component[]{this.comboBoxContainer, this.chipsContainer});
        this.setFullComboBoxWidth(true);
    }

    protected void initListeners() {
        this.cbAvailableItems.addValueChangeListener(this::onCbAvailableItemsValueChanged);
        this.btnClearAll.addClickListener(this::onClickClearAll);
    }

    protected void onCbAvailableItemsValueChanged(AbstractField.ComponentValueChangeEvent<ComboBox<T>, T> event) {
        if (event.getValue() == null || this.isReadOnly()) {
            return;
        }
        this.addItem(event.getValue(), event.isFromClient());
    }

    protected void onClickClearAll(ClickEvent<Button> event) {
        if (this.isReadOnly()) {
            return;
        }
        this.updateValues((Set)this.getEmptyValue(), event.isFromClient());
    }

    protected void setPresentationValue(Set<T> newPresentationValue) {
        this.selectedComponents.removeIf(comp -> !newPresentationValue.contains(comp.getItem()));
        List<Object> existingValues = this.selectedComponents.stream().map(ChipComponent::getItem).toList();
        newPresentationValue.stream().filter(v -> !existingValues.contains(v)).map(item -> {
            ChipComponent chipComponent = (ChipComponent)((Object)((Object)this.chipsSupplier.apply(item)));
            chipComponent.setItemLabelGenerator(this.chipItemLabelGenerator);
            chipComponent.addBtnDeleteClickListener((ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)ev -> {
                if (this.isReadOnly()) {
                    return;
                }
                this.removeItem(item, ev.isFromClient());
            });
            return chipComponent;
        }).forEach(this.selectedComponents::add);
        this.updateUI();
    }

    protected void addItem(T item, boolean isFromClient) {
        LinkedHashSet<T> values = new LinkedHashSet<T>((Collection)this.getValue());
        values.add(item);
        this.updateValues(values, isFromClient);
    }

    protected void removeItem(T item, boolean isFromClient) {
        LinkedHashSet values = new LinkedHashSet((Collection)this.getValue());
        values.remove(item);
        this.updateValues(values, isFromClient);
    }

    protected void updateValues(Set<T> newValues, boolean isFromClient) {
        Set oldValue = (Set)this.getValue();
        this.setModelValue(newValues, isFromClient);
        if (!this.valueEquals(oldValue, newValues)) {
            this.setPresentationValue(newValues);
        }
    }

    protected void updateUI() {
        this.updateSelectedChips();
        this.updateAvailableItems();
        this.updateRequiredIndicatorOfCbAvailableItems();
    }

    protected void updateSelectedChips() {
        this.chipsContainer.removeAll();
        this.chipsContainer.add((Component[])this.selectedComponents.toArray(new ChipComponent[0]));
    }

    protected void updateAvailableItems() {
        ArrayList<T> availableItems = new ArrayList<T>(this.allAvailableItems);
        availableItems.removeAll((Collection)this.getValue());
        this.cbAvailableItems.setItems(availableItems);
    }

    protected void updateRequiredIndicatorOfCbAvailableItems() {
        this.cbAvailableItems.setRequiredIndicatorVisible(this.isRequiredIndicatorVisible());
    }

    public void setItems(Collection<T> items) {
        Objects.requireNonNull(items);
        this.allAvailableItems.clear();
        this.allAvailableItems.addAll(items);
        LinkedHashSet<Object> values = new LinkedHashSet<Object>((Collection)this.getValue());
        values.removeIf(v -> !this.allAvailableItems.contains(v));
        this.updateValues(values, false);
        this.updateUI();
    }

    public Function<T, ChipComponent<T>> getChipsSupplier() {
        return this.chipsSupplier;
    }

    public ChipComboBox<T> withChipsSupplier(SerializableFunction<T, ChipComponent<T>> chipsSupplier) {
        this.setChipsSupplier(chipsSupplier);
        return this;
    }

    public void setChipsSupplier(SerializableFunction<T, ChipComponent<T>> chipsSupplier) {
        this.chipsSupplier = Objects.requireNonNull(chipsSupplier);
    }

    public List<T> getAllAvailableItems() {
        return new ArrayList<T>(this.allAvailableItems);
    }

    public ChipComboBox<T> withAllAvailableItems(Collection<T> allAvailableItems) {
        this.setItems(allAvailableItems);
        return this;
    }

    public String getLabel() {
        return this.cbAvailableItems.getLabel();
    }

    public ChipComboBox<T> withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public void setLabel(String label) {
        this.cbAvailableItems.setLabel(label);
    }

    public String getPlaceholder() {
        return this.cbAvailableItems.getPlaceholder();
    }

    public ChipComboBox<T> withPlaceholder(String placeholder) {
        this.setPlaceholder(placeholder);
        return this;
    }

    public void setPlaceholder(String placeholder) {
        this.cbAvailableItems.setPlaceholder(placeholder);
    }

    public boolean isClearAllButtonVisible() {
        return this.btnClearAll.isVisible();
    }

    public ChipComboBox<T> withClearAllButtonVisible(boolean clearAllButtonVisible) {
        this.setClearAllButtonVisible(clearAllButtonVisible);
        return this;
    }

    public void setClearAllButtonVisible(boolean clearAllButtonVisible) {
        this.btnClearAll.setVisible(clearAllButtonVisible);
    }

    public Component getClearAllIcon() {
        return this.btnClearAll.getIcon();
    }

    public ChipComboBox<T> withClearAllIcon(Component clearAllIcon) {
        this.setClearAllIcon(clearAllIcon);
        return this;
    }

    public void setClearAllIcon(Component clearAllIcon) {
        this.btnClearAll.setIcon(clearAllIcon);
    }

    public ChipComboBox<T> withFullComboBoxWidth(boolean useFullWidth) {
        this.setFullComboBoxWidth(useFullWidth);
        return this;
    }

    public void setFullComboBoxWidth(boolean useFullWidth) {
        if (useFullWidth) {
            this.cbAvailableItems.setWidthFull();
        } else {
            this.cbAvailableItems.setWidth(null);
        }
    }

    public void setChipItemLabelGenerator(ItemLabelGenerator<T> generator) {
        this.chipItemLabelGenerator = Objects.requireNonNull(generator, "The item label generator can not be null");
        this.selectedComponents.forEach(chipComp -> {
            chipComp.setItemLabelGenerator(this.chipItemLabelGenerator);
            chipComp.updateTextFromItemLabelGenerator();
        });
    }

    public ChipComboBox<T> withChipItemLabelGenerator(ItemLabelGenerator<T> generator) {
        this.setChipItemLabelGenerator(generator);
        return this;
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> generator) {
        this.cbAvailableItems.setItemLabelGenerator(generator);
        this.setChipItemLabelGenerator(generator);
    }

    public ChipComboBox<T> withItemLabelGenerator(ItemLabelGenerator<T> generator) {
        this.setItemLabelGenerator(generator);
        return this;
    }

    public void setValue(Set<T> value) {
        if (value == null) {
            this.clear();
            return;
        }
        super.setValue(value);
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.cbAvailableItems.setReadOnly(readOnly);
        this.selectedComponents.forEach(comp -> comp.setReadonly(readOnly));
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.updateRequiredIndicatorOfCbAvailableItems();
    }

    public boolean isRequiredIndicatorVisible() {
        return super.isRequiredIndicatorVisible() && this.isEmpty();
    }

    public void setErrorMessage(String errorMessage) {
        this.cbAvailableItems.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return this.cbAvailableItems.getErrorMessage();
    }

    public void setInvalid(boolean invalid) {
        this.cbAvailableItems.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.cbAvailableItems.isInvalid();
    }

    public void focus() {
        this.getCbAvailableItems().focus();
    }

    public void blur() {
        this.getCbAvailableItems().blur();
    }

    public ComboBox<T> getCbAvailableItems() {
        return this.cbAvailableItems;
    }

    public HorizontalLayout getComboBoxContainer() {
        return this.comboBoxContainer;
    }

    public FlexLayout getChipsContainer() {
        return this.chipsContainer;
    }
}

