/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.selenium.containers.browser;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.testcontainers.utility.DockerImageName;
import software.xdev.testcontainers.selenium.containers.browser.BrowserWebDriverContainer;
import software.xdev.testcontainers.selenium.containers.browser.SeleniumUtils;

public class CapabilitiesBrowserWebDriverContainer<SELF extends CapabilitiesBrowserWebDriverContainer<SELF>>
extends BrowserWebDriverContainer<SELF> {
    protected static final Map<String, DockerImageName> BROWSER_DOCKER_IMAGES = new HashMap<String, DockerImageName>(Map.of("chrome", CHROME_IMAGE, "firefox", FIREFOX_IMAGE, "MicrosoftEdge", EDGE_IMAGE));

    public CapabilitiesBrowserWebDriverContainer(Capabilities capabilities) {
        super(CapabilitiesBrowserWebDriverContainer.getStandardImageForCapabilities(capabilities, SeleniumUtils.getClasspathSeleniumVersion()));
        this.waitStrategy = this.getDefaultWaitStrategy();
    }

    protected static DockerImageName getStandardImageForCapabilities(Capabilities capabilities, String seleniumVersion) {
        return Optional.ofNullable(BROWSER_DOCKER_IMAGES.get(Optional.ofNullable(capabilities).map(Capabilities::getBrowserName).orElse("chrome"))).map(image -> image.withTag(seleniumVersion)).orElseThrow(() -> new UnsupportedOperationException("Unsupported Browser name; Supported: " + String.join((CharSequence)", ", BROWSER_DOCKER_IMAGES.keySet())));
    }

    protected static final class BrowserType {
        public static final String CHROME = "chrome";
        public static final String FIREFOX = "firefox";
        public static final String EDGE = "MicrosoftEdge";

        private BrowserType() {
        }
    }
}

