/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.security.web.authentication.ui.advanced;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public record StylingDefinition(Set<String> classNames, Set<String> styles) {
    public String classNameString() {
        return this.classNames().stream().map(s -> " " + s).collect(Collectors.joining());
    }

    public String styleString() {
        return this.styles().stream().map(s -> s + ";").collect(Collectors.joining());
    }

    public static class Builder {
        protected Set<String> classNames = new LinkedHashSet<String>();
        protected Set<String> styles = new LinkedHashSet<String>();

        public Builder classNames(Set<String> classNames) {
            this.classNames = classNames;
            return this;
        }

        public Builder classNames(String ... classNames) {
            return this.classNames(Set.of(classNames));
        }

        public Builder className(String className) {
            this.classNames.add(className);
            return this;
        }

        public Builder styles(Set<String> styles) {
            this.styles = styles;
            return this;
        }

        public Builder styles(String ... styles) {
            return this.styles(Set.of(styles));
        }

        public Builder style(String style) {
            this.styles.add(style);
            return this;
        }

        public StylingDefinition build() {
            return new StylingDefinition(this.classNames, this.styles);
        }
    }
}

