/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.security.web.authentication.ui.extendable;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.DefaultLoginPageConfigurer;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.ui.DefaultLogoutPageGeneratingFilter;
import software.xdev.spring.security.web.authentication.ui.extendable.FieldAccessor;
import software.xdev.spring.security.web.authentication.ui.extendable.filters.ExtendableDefaultLoginPageGeneratingFilter;
import software.xdev.spring.security.web.authentication.ui.extendable.filters.ExtendableDefaultLogoutPageGeneratingFilter;
import software.xdev.spring.security.web.authentication.ui.extendable.filters.ExtendableDefaultPageGeneratingFilter;
import software.xdev.spring.security.web.authentication.ui.extendable.filters.GeneratingFilterFillDataFrom;

public abstract class ExtendableLoginPageAdapter<SELF extends ExtendableLoginPageAdapter<SELF, SHARED_FILTER, LOGIN_FILTER, LOGOUT_FILTER, H>, SHARED_FILTER extends ExtendableDefaultPageGeneratingFilter, LOGIN_FILTER extends ExtendableDefaultLoginPageGeneratingFilter, LOGOUT_FILTER extends ExtendableDefaultLogoutPageGeneratingFilter, H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<SELF, H> {
    protected final LOGIN_FILTER loginPageGeneratingFilter;
    protected final LOGOUT_FILTER logoutPageGeneratingFilter;
    protected final boolean copyDataFromExistingFilters;
    protected final boolean installUsingInitMethod;
    private Consumer<SHARED_FILTER> customizePages;
    protected Consumer<LOGIN_FILTER> customizeLoginPage;
    protected Consumer<LOGOUT_FILTER> customizeLogoutPage;

    protected ExtendableLoginPageAdapter(Supplier<InitConfiguration<LOGIN_FILTER, LOGOUT_FILTER>> s, Consumer<InitConfiguration<LOGIN_FILTER, LOGOUT_FILTER>> c) {
        this(ExtendableLoginPageAdapter.crateAndApplyConsumer(s, c));
    }

    protected static <T> T crateAndApplyConsumer(Supplier<T> supplier, Consumer<T> consumer) {
        T obj = supplier.get();
        if (consumer != null) {
            consumer.accept(obj);
        }
        return obj;
    }

    protected ExtendableLoginPageAdapter(InitConfiguration<LOGIN_FILTER, LOGOUT_FILTER> initConfig) {
        this(initConfig.getHttpSecurity(), initConfig.getLoginPageGeneratingFilterSupplier(), initConfig.getLogoutPageGeneratingFilterSupplier(), initConfig.isCopyDataFromExistingFilters(), initConfig.getInstallWith());
    }

    protected ExtendableLoginPageAdapter(HttpSecurity httpSecurity, Supplier<LOGIN_FILTER> loginPageGeneratingFilterSupplier, Supplier<LOGOUT_FILTER> logoutPageGeneratingFilterSupplier, boolean copyDataFromExistingFilters, InstallWith installWith) {
        this.loginPageGeneratingFilter = (ExtendableDefaultLoginPageGeneratingFilter)loginPageGeneratingFilterSupplier.get();
        this.logoutPageGeneratingFilter = (ExtendableDefaultLogoutPageGeneratingFilter)logoutPageGeneratingFilterSupplier.get();
        this.copyDataFromExistingFilters = copyDataFromExistingFilters;
        boolean bl = this.installUsingInitMethod = installWith == InstallWith.INIT_METHOD || installWith == null && httpSecurity == null;
        if (!this.installUsingInitMethod) {
            this.install((DefaultLoginPageConfigurer)httpSecurity.getConfigurer(DefaultLoginPageConfigurer.class));
        }
    }

    public void init(H http) {
        if (!this.installUsingInitMethod) {
            return;
        }
        this.install((DefaultLoginPageConfigurer)http.getConfigurer(DefaultLoginPageConfigurer.class));
        http.setSharedObject(DefaultLoginPageGeneratingFilter.class, this.loginPageGeneratingFilter);
    }

    protected void install(DefaultLoginPageConfigurer loginPageConfigurer) {
        Optional.ofNullable(loginPageConfigurer).ifPresent(c -> {
            FieldAccessor fieldAccessor = new FieldAccessor();
            Stream.of(new ProcessInfo<DefaultLoginPageGeneratingFilter, LOGIN_FILTER>("loginPageGeneratingFilter", DefaultLoginPageGeneratingFilter.class, this.loginPageGeneratingFilter), new ProcessInfo<DefaultLogoutPageGeneratingFilter, LOGOUT_FILTER>("logoutPageGeneratingFilter", DefaultLogoutPageGeneratingFilter.class, this.logoutPageGeneratingFilter)).forEach(p -> {
                Class<DefaultLoginPageConfigurer> clazz = DefaultLoginPageConfigurer.class;
                if (this.copyDataFromExistingFilters) {
                    p.filterFillDataFrom(fieldAccessor.getValue(clazz, c, p.fieldName()));
                }
                fieldAccessor.setValue(clazz, c, p.fieldName(), p.filter());
            });
        });
    }

    public void configure(H builder) {
        Optional.ofNullable(this.customizePages).ifPresent(c -> Stream.of(this.loginPageGeneratingFilter, this.logoutPageGeneratingFilter).forEach(f -> c.accept((ExtendableDefaultPageGeneratingFilter)f)));
        Optional.ofNullable(this.customizeLoginPage).ifPresent(c -> c.accept(this.loginPageGeneratingFilter));
        Optional.ofNullable(this.customizeLogoutPage).ifPresent(c -> c.accept(this.logoutPageGeneratingFilter));
    }

    public SELF customizePages(Consumer<SHARED_FILTER> customizePages) {
        this.customizePages = customizePages;
        return this.self();
    }

    public SELF customizeLoginPage(Consumer<LOGIN_FILTER> customizeLoginPage) {
        this.customizeLoginPage = customizeLoginPage;
        return this.self();
    }

    public SELF customizeLogoutPage(Consumer<LOGOUT_FILTER> customizeLogoutPage) {
        this.customizeLogoutPage = customizeLogoutPage;
        return this.self();
    }

    protected SELF self() {
        return (SELF)((Object)this);
    }

    public static class InitConfiguration<LOGIN_FILTER extends ExtendableDefaultLoginPageGeneratingFilter, LOGOUT_FILTER extends ExtendableDefaultLogoutPageGeneratingFilter> {
        protected HttpSecurity httpSecurity;
        protected Supplier<LOGIN_FILTER> loginPageGeneratingFilterSupplier;
        protected Supplier<LOGOUT_FILTER> logoutPageGeneratingFilterSupplier;
        protected boolean copyDataFromExistingFilters = true;
        protected InstallWith installWith;

        public InitConfiguration(Supplier<LOGIN_FILTER> loginPageGeneratingFilterSupplier, Supplier<LOGOUT_FILTER> logoutPageGeneratingFilterSupplier) {
            this.loginPageGeneratingFilterSupplier = loginPageGeneratingFilterSupplier;
            this.logoutPageGeneratingFilterSupplier = logoutPageGeneratingFilterSupplier;
        }

        public InitConfiguration<LOGIN_FILTER, LOGOUT_FILTER> httpSecurity(HttpSecurity httpSecurity) {
            this.httpSecurity = httpSecurity;
            return this;
        }

        public InitConfiguration<LOGIN_FILTER, LOGOUT_FILTER> loginPageGeneratingFilterSupplier(Supplier<LOGIN_FILTER> loginPageGeneratingFilterSupplier) {
            this.loginPageGeneratingFilterSupplier = loginPageGeneratingFilterSupplier;
            return this;
        }

        public InitConfiguration<LOGIN_FILTER, LOGOUT_FILTER> logoutPageGeneratingFilterSupplier(Supplier<LOGOUT_FILTER> logoutPageGeneratingFilterSupplier) {
            this.logoutPageGeneratingFilterSupplier = logoutPageGeneratingFilterSupplier;
            return this;
        }

        public InitConfiguration<LOGIN_FILTER, LOGOUT_FILTER> copyDataFromExistingFilters(boolean copyDataFromExistingFilters) {
            this.copyDataFromExistingFilters = copyDataFromExistingFilters;
            return this;
        }

        public InitConfiguration<LOGIN_FILTER, LOGOUT_FILTER> installWith(InstallWith installWith) {
            this.installWith = installWith;
            return this;
        }

        public HttpSecurity getHttpSecurity() {
            return this.httpSecurity;
        }

        public Supplier<LOGIN_FILTER> getLoginPageGeneratingFilterSupplier() {
            return this.loginPageGeneratingFilterSupplier;
        }

        public Supplier<LOGOUT_FILTER> getLogoutPageGeneratingFilterSupplier() {
            return this.logoutPageGeneratingFilterSupplier;
        }

        public boolean isCopyDataFromExistingFilters() {
            return this.copyDataFromExistingFilters;
        }

        public InstallWith getInstallWith() {
            return this.installWith;
        }
    }

    public static enum InstallWith {
        CONSTRUCTOR,
        INIT_METHOD;

    }

    protected record ProcessInfo<B, F extends GeneratingFilterFillDataFrom<B>>(String fieldName, Class<B> baseFilterClass, F filter) {
        public void filterFillDataFrom(Object source) {
            Optional.ofNullable(source).filter(this.baseFilterClass()::isInstance).map(this.baseFilterClass()::cast).ifPresent(arg_0 -> this.filter().fillDataFrom(arg_0));
        }
    }
}

