/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.security.web.authentication.ui.extendable.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;
import software.xdev.spring.security.web.authentication.ui.extendable.filters.ExtendableDefaultPageGeneratingFilter;
import software.xdev.spring.security.web.authentication.ui.extendable.filters.GeneratingFilterFillDataFrom;

public class ExtendableDefaultLoginPageGeneratingFilter
extends DefaultLoginPageGeneratingFilter
implements GeneratingFilterFillDataFrom<DefaultLoginPageGeneratingFilter>,
ExtendableDefaultPageGeneratingFilter {
    protected String loginPageUrl;
    protected String logoutSuccessUrl;
    protected String failureUrl;
    protected boolean formLoginEnabled;
    protected boolean oauth2LoginEnabled;
    protected boolean saml2LoginEnabled;
    protected String authenticationUrl;
    protected String usernameParameter;
    protected String passwordParameter;
    protected String rememberMeParameter;
    protected Map<String, String> oauth2AuthenticationUrlToClientName;
    protected Map<String, String> saml2AuthenticationUrlToProviderName;
    protected Function<HttpServletRequest, Map<String, String>> resolveHiddenInputs = request -> Collections.emptyMap();

    @Override
    public void fillDataFrom(DefaultLoginPageGeneratingFilter source) {
        this.fillDataFrom(DefaultLoginPageGeneratingFilter.class, source, Set.of(new GeneratingFilterFillDataFrom.CopyInfo<String>("loginPageUrl", this::setLoginPageUrl), new GeneratingFilterFillDataFrom.CopyInfo<String>("logoutSuccessUrl", this::setLogoutSuccessUrl), new GeneratingFilterFillDataFrom.CopyInfo<String>("failureUrl", this::setFailureUrl), new GeneratingFilterFillDataFrom.CopyInfo<Boolean>("formLoginEnabled", this::setFormLoginEnabled), new GeneratingFilterFillDataFrom.CopyInfo<Boolean>("oauth2LoginEnabled", this::setOauth2LoginEnabled), new GeneratingFilterFillDataFrom.CopyInfo<Boolean>("saml2LoginEnabled", this::setSaml2LoginEnabled), new GeneratingFilterFillDataFrom.CopyInfo<String>("authenticationUrl", this::setAuthenticationUrl), new GeneratingFilterFillDataFrom.CopyInfo<String>("usernameParameter", this::setUsernameParameter), new GeneratingFilterFillDataFrom.CopyInfo<String>("passwordParameter", this::setPasswordParameter), new GeneratingFilterFillDataFrom.CopyInfo<String>("rememberMeParameter", this::setRememberMeParameter), new GeneratingFilterFillDataFrom.CopyInfo<Map>("oauth2AuthenticationUrlToClientName", this::setOauth2AuthenticationUrlToClientName), new GeneratingFilterFillDataFrom.CopyInfo<Map>("saml2AuthenticationUrlToProviderName", this::setSaml2AuthenticationUrlToProviderName), new GeneratingFilterFillDataFrom.CopyInfo<Function>("resolveHiddenInputs", this::setResolveHiddenInputs)));
    }

    public void setResolveHiddenInputs(Function<HttpServletRequest, Map<String, String>> resolveHiddenInputs) {
        Assert.notNull(resolveHiddenInputs, (String)"resolveHiddenInputs cannot be null");
        this.resolveHiddenInputs = resolveHiddenInputs;
    }

    public boolean isEnabled() {
        return this.formLoginEnabled || this.oauth2LoginEnabled || this.saml2LoginEnabled;
    }

    public void setLogoutSuccessUrl(String logoutSuccessUrl) {
        this.logoutSuccessUrl = logoutSuccessUrl;
    }

    public String getLoginPageUrl() {
        return this.loginPageUrl;
    }

    public void setLoginPageUrl(String loginPageUrl) {
        this.loginPageUrl = loginPageUrl;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public void setFormLoginEnabled(boolean formLoginEnabled) {
        this.formLoginEnabled = formLoginEnabled;
    }

    public void setOauth2LoginEnabled(boolean oauth2LoginEnabled) {
        this.oauth2LoginEnabled = oauth2LoginEnabled;
    }

    public void setSaml2LoginEnabled(boolean saml2LoginEnabled) {
        this.saml2LoginEnabled = saml2LoginEnabled;
    }

    public void setAuthenticationUrl(String authenticationUrl) {
        this.authenticationUrl = authenticationUrl;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public void setRememberMeParameter(String rememberMeParameter) {
        this.rememberMeParameter = rememberMeParameter;
    }

    public void setOauth2AuthenticationUrlToClientName(Map<String, String> oauth2AuthenticationUrlToClientName) {
        this.oauth2AuthenticationUrlToClientName = oauth2AuthenticationUrlToClientName;
    }

    public void setSaml2AuthenticationUrlToProviderName(Map<String, String> saml2AuthenticationUrlToProviderName) {
        this.saml2AuthenticationUrlToProviderName = saml2AuthenticationUrlToProviderName;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean loginError = this.isErrorPage(request);
        boolean logoutSuccess = this.isLogoutSuccess(request);
        if (this.isLoginUrlRequest(request) || loginError || logoutSuccess) {
            String loginPageHtml = this.generateLoginPageHtml(request, loginError, logoutSuccess);
            response.setContentType("text/html;charset=UTF-8");
            response.setContentLength(loginPageHtml.getBytes(StandardCharsets.UTF_8).length);
            response.getWriter().write(loginPageHtml);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected String generateLoginPageHtml(HttpServletRequest request, boolean loginError, boolean logoutSuccess) {
        String url;
        String errorMsg = loginError ? this.getLoginErrorMessage(request) : "Invalid credentials";
        String contextPath = request.getContextPath();
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>\n");
        sb.append("<html lang=\"en\">\n");
        sb.append("  <head>\n");
        sb.append("    <meta charset=\"utf-8\">\n");
        sb.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">\n");
        sb.append("    <meta name=\"description\" content=\"\">\n");
        sb.append("    <meta name=\"author\" content=\"\">\n");
        sb.append("    <title>Please sign in</title>\n");
        sb.append("    <link href=\"https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/css/bootstrap.min.css\" rel=\"stylesheet\" integrity=\"sha384-/Y6pD6FV/Vv2HJnA6t+vslU6fwYXjCFtcEpHbNJ0lyAFsXTsjBbfaDjzALeQsN6M\" crossorigin=\"anonymous\">\n");
        sb.append("    <link href=\"https://getbootstrap.com/docs/4.0/examples/signin/signin.css\" rel=\"stylesheet\" integrity=\"sha384-oOE/3m0LUMPub4kaC09mrdEhIc+e3exm4xOGxAmuFXhBNF4hcg/6MiAXAf5p0P56\" crossorigin=\"anonymous\"/>\n");
        sb.append("  </head>\n");
        sb.append("  <body>\n");
        sb.append("     <div class=\"container\">\n");
        if (this.formLoginEnabled) {
            sb.append("      <form class=\"form-signin\" method=\"post\" action=\"" + contextPath + this.authenticationUrl + "\">\n");
            sb.append("        <h2 class=\"form-signin-heading\">Please sign in</h2>\n");
            sb.append(this.createError(loginError, errorMsg) + this.createLogoutSuccess(logoutSuccess) + "        <p>\n");
            sb.append("          <label for=\"username\" class=\"sr-only\">Username</label>\n");
            sb.append("          <input type=\"text\" id=\"username\" name=\"" + this.usernameParameter + "\" class=\"form-control\" placeholder=\"Username\" required autofocus>\n");
            sb.append("        </p>\n");
            sb.append("        <p>\n");
            sb.append("          <label for=\"password\" class=\"sr-only\">Password</label>\n");
            sb.append("          <input type=\"password\" id=\"password\" name=\"" + this.passwordParameter + "\" class=\"form-control\" placeholder=\"Password\" required>\n");
            sb.append("        </p>\n");
            sb.append(this.createRememberMe(this.rememberMeParameter) + this.renderHiddenInputs(request));
            sb.append("        <button class=\"btn btn-lg btn-primary btn-block\" type=\"submit\">Sign in</button>\n");
            sb.append("      </form>\n");
        }
        if (this.oauth2LoginEnabled) {
            sb.append("<h2 class=\"form-signin-heading\">Login with OAuth 2.0</h2>");
            sb.append(this.createError(loginError, errorMsg));
            sb.append(this.createLogoutSuccess(logoutSuccess));
            sb.append("<table class=\"table table-striped\">\n");
            for (Map.Entry<String, String> clientAuthenticationUrlToClientName : this.oauth2AuthenticationUrlToClientName.entrySet()) {
                sb.append(" <tr><td>");
                url = clientAuthenticationUrlToClientName.getKey();
                sb.append("<a href=\"").append(contextPath).append(url).append("\">");
                String clientName = HtmlUtils.htmlEscape((String)clientAuthenticationUrlToClientName.getValue());
                sb.append(clientName);
                sb.append("</a>");
                sb.append("</td></tr>\n");
            }
            sb.append("</table>\n");
        }
        if (this.saml2LoginEnabled) {
            sb.append("<h2 class=\"form-signin-heading\">Login with SAML 2.0</h2>");
            sb.append(this.createError(loginError, errorMsg));
            sb.append(this.createLogoutSuccess(logoutSuccess));
            sb.append("<table class=\"table table-striped\">\n");
            for (Map.Entry<String, String> relyingPartyUrlToName : this.saml2AuthenticationUrlToProviderName.entrySet()) {
                sb.append(" <tr><td>");
                url = relyingPartyUrlToName.getKey();
                sb.append("<a href=\"").append(contextPath).append(url).append("\">");
                String partyName = HtmlUtils.htmlEscape((String)relyingPartyUrlToName.getValue());
                sb.append(partyName);
                sb.append("</a>");
                sb.append("</td></tr>\n");
            }
            sb.append("</table>\n");
        }
        sb.append("</div>\n");
        sb.append("</body></html>");
        return sb.toString();
    }

    protected String getLoginErrorMessage(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return "Invalid credentials";
        }
        Object object = session.getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        if (!(object instanceof AuthenticationException)) {
            return "Invalid credentials";
        }
        AuthenticationException exception = (AuthenticationException)object;
        if (!StringUtils.hasText((String)exception.getMessage())) {
            return "Invalid credentials";
        }
        return exception.getMessage();
    }

    protected String renderHiddenInputs(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> input : this.resolveHiddenInputs.apply(request).entrySet()) {
            sb.append("<input name=\"");
            sb.append(input.getKey());
            sb.append("\" type=\"hidden\" value=\"");
            sb.append(input.getValue());
            sb.append("\" />\n");
        }
        return sb.toString();
    }

    protected String createRememberMe(String paramName) {
        if (paramName == null) {
            return "";
        }
        return "<p><input type='checkbox' name='" + paramName + "'/> Remember me on this computer.</p>\n";
    }

    protected boolean isLogoutSuccess(HttpServletRequest request) {
        return this.logoutSuccessUrl != null && this.matches(request, this.logoutSuccessUrl);
    }

    protected boolean isLoginUrlRequest(HttpServletRequest request) {
        return this.matches(request, this.loginPageUrl);
    }

    protected boolean isErrorPage(HttpServletRequest request) {
        return this.matches(request, this.failureUrl);
    }

    protected String createError(boolean isError, String message) {
        if (!isError) {
            return "";
        }
        return "<div class=\"alert alert-danger\" role=\"alert\">" + HtmlUtils.htmlEscape((String)message) + "</div>";
    }

    protected String createLogoutSuccess(boolean isLogoutSuccess) {
        if (!isLogoutSuccess) {
            return "";
        }
        return "<div class=\"alert alert-success\" role=\"alert\">You have been signed out</div>";
    }

    protected boolean matches(HttpServletRequest request, String url) {
        if (!"GET".equals(request.getMethod()) || url == null) {
            return false;
        }
        Object uri = request.getRequestURI();
        int pathParamIndex = ((String)uri).indexOf(59);
        if (pathParamIndex > 0) {
            uri = ((String)uri).substring(0, pathParamIndex);
        }
        if (request.getQueryString() != null) {
            uri = (String)uri + "?" + request.getQueryString();
        }
        if ("".equals(request.getContextPath())) {
            return ((String)uri).equals(url);
        }
        return ((String)uri).equals(request.getContextPath() + url);
    }
}

