/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.transactions;

import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import software.xdev.spring.data.eclipse.store.transactions.EclipseStoreExistingTransactionObject;
import software.xdev.spring.data.eclipse.store.transactions.EclipseStoreNoTransactionObject;
import software.xdev.spring.data.eclipse.store.transactions.EclipseStoreTransaction;

public class EclipseStoreTransactionManager
extends AbstractPlatformTransactionManager {
    private static final String TRANSACTION_MANAGER = "ATransactionManagerForThisThread";

    protected Object doGetTransaction() {
        EclipseStoreExistingTransactionObject transactionObject = (EclipseStoreExistingTransactionObject)TransactionSynchronizationManager.getResource((Object)TRANSACTION_MANAGER);
        return transactionObject == null ? new EclipseStoreExistingTransactionObject() : transactionObject;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        EclipseStoreExistingTransactionObject transactionObject = this.extractEclipseStoreTransaction(transaction);
        transactionObject.startTransaction();
        TransactionSynchronizationManager.bindResource((Object)TRANSACTION_MANAGER, (Object)transactionObject);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        this.extractEclipseStoreTransaction(status.getTransaction()).commitTransaction();
    }

    protected void doRollback(DefaultTransactionStatus status) {
        this.extractEclipseStoreTransaction(status.getTransaction()).rollbackTransaction();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        TransactionSynchronizationManager.unbindResource((Object)TRANSACTION_MANAGER);
    }

    private EclipseStoreExistingTransactionObject extractEclipseStoreTransaction(Object transaction) {
        Assert.isInstanceOf(EclipseStoreExistingTransactionObject.class, (Object)transaction, () -> String.format("Expected to find a %s but it turned out to be %s.", EclipseStoreExistingTransactionObject.class, transaction.getClass()));
        return (EclipseStoreExistingTransactionObject)transaction;
    }

    public EclipseStoreTransaction getTransaction() {
        EclipseStoreTransaction transactionObject = (EclipseStoreTransaction)TransactionSynchronizationManager.getResource((Object)TRANSACTION_MANAGER);
        return transactionObject == null ? new EclipseStoreNoTransactionObject() : transactionObject;
    }
}

