/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.id.strategy;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Supplier;
import software.xdev.spring.data.eclipse.store.exceptions.IdGeneratorNotSupportedException;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.strategy.auto.AutoIntegerIdFinder;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.strategy.auto.AutoLongIdFinder;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.strategy.auto.AutoStringIdFinder;

public interface IdFinder<ID> {
    public static <ID> IdFinder<ID> createIdFinder(Field idField, GeneratedValue generatedValueAnnotation, Supplier<Object> lastIdGetter) {
        Objects.requireNonNull(lastIdGetter);
        if (generatedValueAnnotation.strategy() == GenerationType.AUTO) {
            if (Integer.class.isAssignableFrom(idField.getType()) || Integer.TYPE.isAssignableFrom(idField.getType())) {
                return new AutoIntegerIdFinder(lastIdGetter);
            }
            if (idField.getType().equals(String.class)) {
                return new AutoStringIdFinder(lastIdGetter);
            }
            if (Long.class.isAssignableFrom(idField.getType()) || Long.TYPE.isAssignableFrom(idField.getType())) {
                return new AutoLongIdFinder(lastIdGetter);
            }
        }
        throw new IdGeneratorNotSupportedException(String.format("Id generator with strategy %s for type %s is not supported.", generatedValueAnnotation.strategy(), idField.getType().getSimpleName()));
    }

    public ID findId();
}

