/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import software.xdev.spring.data.eclipse.store.repository.config.DefaultEclipseStoreClientConfiguration;
import software.xdev.spring.data.eclipse.store.repository.config.EclipseStoreClientConfiguration;
import software.xdev.spring.data.eclipse.store.repository.support.EclipseStoreRepositoryFactory;

@ComponentScan(value={"software.xdev.spring.data.eclipse.store.repository", "software.xdev.spring.data.eclipse.store.transactions"})
@Component
public class EclipseStoreRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseStoreRepositoryFactoryBean.class);
    private EclipseStoreClientConfiguration configuration;
    private BeanFactory beanFactory;
    private Class<?> configurationClass;

    public EclipseStoreRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setConfigurationClass(Class<?> configurationClass) {
        this.configurationClass = configurationClass;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this.beanFactory = beanFactory;
    }

    @Nonnull
    protected RepositoryFactorySupport createRepositoryFactory() {
        EclipseStoreClientConfiguration ensuredConfiguration = this.ensureConfiguration();
        return new EclipseStoreRepositoryFactory(ensuredConfiguration.getStorageInstance(), (PlatformTransactionManager)ensuredConfiguration.getTransactionManagerInstance());
    }

    private EclipseStoreClientConfiguration ensureConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
        }
        return this.configuration;
    }

    private EclipseStoreClientConfiguration createConfiguration() {
        Objects.requireNonNull(this.beanFactory);
        try {
            Object object;
            if (this.configurationClass != null && (object = this.beanFactory.getBean(this.configurationClass)) instanceof EclipseStoreClientConfiguration) {
                EclipseStoreClientConfiguration eclipseStoreConfiguration = (EclipseStoreClientConfiguration)object;
                return eclipseStoreConfiguration;
            }
        }
        catch (BeansException ex) {
            LOG.warn("Could not initiate Bean %s. Using %s instead.".formatted(this.configurationClass.getSimpleName(), DefaultEclipseStoreClientConfiguration.class.getSimpleName()), (Throwable)ex);
        }
        return (EclipseStoreClientConfiguration)this.beanFactory.getBean(DefaultEclipseStoreClientConfiguration.class);
    }
}

