/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query.executors;

import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import software.xdev.spring.data.eclipse.store.core.EntityProvider;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;
import software.xdev.spring.data.eclipse.store.repository.query.executors.EntitySorter;
import software.xdev.spring.data.eclipse.store.repository.query.executors.QueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;

public class SingleOptionalQueryExecutor<T>
implements QueryExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleOptionalQueryExecutor.class);
    private final Criteria<T> criteria;
    private final WorkingCopier<T> copier;
    private final Optional<Sort> staticSort;

    public SingleOptionalQueryExecutor(WorkingCopier<T> copier, Criteria<T> criteria, Sort sort) {
        this.criteria = Objects.requireNonNull(criteria);
        this.copier = Objects.requireNonNull(copier);
        this.staticSort = Optional.ofNullable(sort);
    }

    @Override
    public Optional<T> execute(Class<T> clazz, @Nullable EntityProvider<T> entities, @Nullable Object[] values) {
        Objects.requireNonNull(clazz);
        if (entities == null || entities.isEmpty()) {
            return Optional.empty();
        }
        Stream<Object> entityStream = entities.stream().filter(this.criteria::evaluate).map(this.copier::copy);
        if (this.staticSort.isPresent()) {
            entityStream = EntitySorter.sortEntitiesStream(clazz, this.staticSort.get(), entityStream);
        }
        Optional<Object> result = entityStream.findFirst();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Query for class {} found an entity: {}", (Object)clazz.getSimpleName(), (Object)result.isPresent());
        }
        return result;
    }
}

