/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Method;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.TypeInformation;
import software.xdev.spring.data.eclipse.store.core.EntityListProvider;
import software.xdev.spring.data.eclipse.store.repository.query.EclipseStoreQueryCreator;
import software.xdev.spring.data.eclipse.store.repository.query.executors.QueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;

public class StringBasedEclipseStoreQueryProvider<T>
implements RepositoryQuery {
    private static final Logger LOG = LoggerFactory.getLogger(StringBasedEclipseStoreQueryProvider.class);
    private final PartTree tree;
    private final Parameters<?, ?> parameters;
    private final EntityListProvider entityListProvider;
    private final Class<T> domainClass;
    private final TypeInformation<?> typeInformation;
    private final WorkingCopier<T> copier;
    private final QueryMethod queryMethod;

    public StringBasedEclipseStoreQueryProvider(QueryMethod queryMethod, Method method, Class<T> domainClass, EntityListProvider entityListProvider, WorkingCopier<T> copier) {
        Objects.requireNonNull(method);
        this.queryMethod = queryMethod;
        this.domainClass = Objects.requireNonNull(domainClass);
        this.entityListProvider = Objects.requireNonNull(entityListProvider);
        this.tree = new PartTree(method.getName(), domainClass);
        this.typeInformation = TypeInformation.fromReturnTypeOf((Method)method);
        this.parameters = queryMethod.getParameters();
        this.copier = Objects.requireNonNull(copier);
    }

    @Nonnull
    public Object execute(@Nonnull Object[] values) {
        Objects.requireNonNull(values);
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.parameters, values);
        EclipseStoreQueryCreator<T> creator = new EclipseStoreQueryCreator<T>(this.domainClass, this.typeInformation, this.copier, this.tree, (ParameterAccessor)accessor);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing query {}...", (Object)this.queryMethod);
        }
        Object result = ((QueryExecutor)creator.createQuery()).execute(this.domainClass, this.entityListProvider.getEntityProvider(this.domainClass), values);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done executing query {}.", (Object)this.queryMethod);
        }
        return result;
    }

    @Nonnull
    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }
}

