/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.core.EntityProvider;
import software.xdev.spring.data.eclipse.store.core.IdentitySet;

public class EntitySetCollector {
    private static final Logger LOG = LoggerFactory.getLogger(EntitySetCollector.class);
    private final Map<Class<?>, EntityProvider<?>> childClassToParentSets = new HashMap();

    public <T> EntitySetCollector(Function<Class<T>, IdentitySet<T>> entityLists, Set<Class<?>> entityClasses) {
        this.buildParentClassList(entityLists, entityClasses);
    }

    private <T> void buildParentClassList(Function<Class<T>, IdentitySet<T>> entityLists, Set<Class<?>> entityClasses) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing parent class list...");
        }
        for (Class<?> possibleParentEntry : entityClasses) {
            for (Class<?> possibleChildEntry : entityClasses) {
                this.childClassToParentSets.putIfAbsent(possibleChildEntry, new EntityProvider());
                if (!possibleChildEntry.isAssignableFrom(possibleParentEntry)) continue;
                this.addIdentitySet(this.childClassToParentSets.get(possibleChildEntry), entityLists, possibleParentEntry);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done initializing parent class list.");
        }
    }

    private <T> void addIdentitySet(EntityProvider<T> entities, Function<Class<T>, IdentitySet<T>> entityLists, Class<T> possibleParentEntry) {
        entities.addIdentitySet(entityLists.apply(possibleParentEntry));
    }

    public <T> EntityProvider<T> getRelatedIdentitySets(Class<T> clazz) {
        return this.childClassToParentSets.get(clazz);
    }
}

