/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.importer;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.metamodel.EntityType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.repository.EclipseStoreStorage;
import software.xdev.spring.data.eclipse.store.repository.SupportedChecker;
import software.xdev.spring.data.eclipse.store.repository.config.EclipseStoreClientConfiguration;
import software.xdev.spring.data.eclipse.store.repository.support.SimpleEclipseStoreRepository;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.IdManager;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.RecursiveWorkingCopier;
import software.xdev.spring.data.eclipse.store.transactions.EclipseStoreTransactionManager;

public class EclipseStoreDataImporter {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseStoreDataImporter.class);
    private final EclipseStoreClientConfiguration configuration;

    public EclipseStoreDataImporter(EclipseStoreClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public List<SimpleEclipseStoreRepository<?, ?>> importData(EntityManagerFactory ... entityManagerFactories) {
        return this.importData(Arrays.stream(entityManagerFactories));
    }

    public List<SimpleEclipseStoreRepository<?, ?>> importData(Iterable<EntityManagerFactory> entityManagerFactories) {
        return this.importData(StreamSupport.stream(entityManagerFactories.spliterator(), false));
    }

    public List<SimpleEclipseStoreRepository<?, ?>> importData(Stream<EntityManagerFactory> entityManagerFactories) {
        LOG.info("Start importing data from JPA Repositories to EclipseStore...");
        List<EntityManagerSupplierRepositoryListPair> allRepositories = entityManagerFactories.map(this::createEclipseStoreRepositoriesFromEntityManagerFactory).toList();
        LOG.info("Found {} repositories to export data from.", (Object)allRepositories.size());
        return this.importData(allRepositories);
    }

    public List<SimpleEclipseStoreRepository<?, ?>> importData(EntityManager ... entityManagers) {
        LOG.info("Start importing data from JPA Repositories to EclipseStore...");
        List<EntityManagerSupplierRepositoryListPair> allRepositories = Arrays.stream(entityManagers).map(this::createEclipseStoreRepositoriesFromEntityManager).toList();
        LOG.info("Found {} repositories to export data from.", (Object)allRepositories.size());
        return this.importData(allRepositories);
    }

    private List<SimpleEclipseStoreRepository<?, ?>> importData(List<EntityManagerSupplierRepositoryListPair> allRepositories) {
        allRepositories.forEach(entityManagerSupplierRepositoryListPair -> entityManagerSupplierRepositoryListPair.classRepositoryPairs.forEach(classRepositoryPair -> this.copyData((EntityManagerSupplierRepositoryListPair)entityManagerSupplierRepositoryListPair, (ClassRepositoryPair)classRepositoryPair)));
        LOG.info("Done importing data from JPA Repositories to EclipseStore.");
        return allRepositories.stream().map(EntityManagerSupplierRepositoryListPair::classRepositoryPairs).flatMap(Collection::stream).map(ClassRepositoryPair::repository).collect(Collectors.toList());
    }

    private <T> void copyData(EntityManagerSupplierRepositoryListPair entityManagerSupplierRepositoryListPair, ClassRepositoryPair<T> classRepositoryPair) {
        try (EntityManager entityManager = entityManagerSupplierRepositoryListPair.entityManagerSupplier().get();){
            this.copyData(entityManager, classRepositoryPair);
        }
    }

    private <T> void copyData(EntityManager entityManager, ClassRepositoryPair<T> classRepositoryPair) {
        String className = classRepositoryPair.domainClass.getName();
        LOG.info("Loading entities of {}...", (Object)className);
        List existingEntitiesToExport = entityManager.createQuery("SELECT c FROM " + className + " c", classRepositoryPair.domainClass).getResultList();
        LOG.info("Loaded {} entities of type {} to export.", (Object)existingEntitiesToExport.size(), (Object)className);
        LOG.info("Saving {} entities of type {} to the EclipseStore Repository...", (Object)existingEntitiesToExport.size(), (Object)className);
        classRepositoryPair.repository.saveAll((Iterable)existingEntitiesToExport);
        LOG.info("Done saving entities of type {}. The EclipseStore now holds {} entities of that type.", (Object)className, (Object)classRepositoryPair.repository.count());
    }

    private EntityManagerSupplierRepositoryListPair createEclipseStoreRepositoriesFromEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        ArrayList repositoryList = new ArrayList();
        entityManagerFactory.getMetamodel().getEntities().forEach(entityType -> this.createRepositoryForType((EntityType)entityType, repositoryList));
        return new EntityManagerSupplierRepositoryListPair(() -> entityManagerFactory.createEntityManager(), repositoryList);
    }

    private EntityManagerSupplierRepositoryListPair createEclipseStoreRepositoriesFromEntityManager(EntityManager entityManager) {
        ArrayList repositoryList = new ArrayList();
        entityManager.getMetamodel().getEntities().forEach(entityType -> this.createRepositoryForType((EntityType)entityType, repositoryList));
        return new EntityManagerSupplierRepositoryListPair(() -> entityManager, repositoryList);
    }

    private <T> void createRepositoryForType(EntityType<T> entityType, List<ClassRepositoryPair<?>> repositoryList) {
        Class javaType = entityType.getJavaType();
        repositoryList.add(new ClassRepositoryPair<T>(javaType, this.createEclipseStoreRepo(javaType)));
    }

    private <T> SimpleEclipseStoreRepository<T, ?> createEclipseStoreRepo(Class<T> domainClass) {
        EclipseStoreStorage storageInstance = this.configuration.getStorageInstance();
        IdManager idManager = storageInstance.ensureIdManager(domainClass);
        return new SimpleEclipseStoreRepository(storageInstance, new RecursiveWorkingCopier<T>(domainClass, storageInstance.getRegistry(), storageInstance, storageInstance, new SupportedChecker.Implementation(), storageInstance), domainClass, new EclipseStoreTransactionManager(), idManager);
    }

    private record EntityManagerSupplierRepositoryListPair(Supplier<EntityManager> entityManagerSupplier, List<ClassRepositoryPair<?>> classRepositoryPairs) {
    }

    private record ClassRepositoryPair<T>(Class<T> domainClass, SimpleEclipseStoreRepository<T, ?> repository) {
    }
}

