/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query.executors;

import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;
import software.xdev.spring.data.eclipse.store.repository.query.executors.PageableSortableCollectionQuerier;
import software.xdev.spring.data.eclipse.store.repository.query.executors.QueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;

public class ListQueryExecutor<T>
implements QueryExecutor<T> {
    private final PageableSortableCollectionQuerier<T> querier;

    public ListQueryExecutor(WorkingCopier<T> copier, Criteria<T> criteria) {
        this.querier = new PageableSortableCollectionQuerier<T>(copier, criteria);
    }

    public ListQueryExecutor(WorkingCopier<T> copier, Criteria<T> criteria, Sort sort) {
        this.querier = new PageableSortableCollectionQuerier<T>(copier, criteria, sort);
    }

    @Override
    public List<T> execute(Class<T> clazz, @Nullable Collection<T> entities, Object[] values) {
        Objects.requireNonNull(clazz);
        if (entities == null || entities.isEmpty()) {
            return List.of();
        }
        if (values != null && values.length > 0) {
            Object object = values[values.length - 1];
            if (object instanceof Pageable) {
                Pageable pageable = (Pageable)object;
                return this.querier.getEntities(entities, pageable, clazz);
            }
            object = values[values.length - 1];
            if (object instanceof Sort) {
                Sort sort = (Sort)object;
                return this.querier.getEntities(entities, clazz, sort);
            }
        }
        return this.querier.getEntities(entities, clazz);
    }
}

