/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query.executors;

import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;
import software.xdev.spring.data.eclipse.store.repository.query.executors.QueryExecutor;

public class ExistsQueryExecutor<T>
implements QueryExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ExistsQueryExecutor.class);
    private final Criteria<T> criteria;

    public ExistsQueryExecutor(Criteria<T> criteria) {
        this.criteria = Objects.requireNonNull(criteria);
    }

    @Override
    public Boolean execute(Class<T> clazz, @Nullable Collection<T> entities, @Nullable Object[] values) {
        Objects.requireNonNull(clazz);
        if (entities == null || entities.isEmpty()) {
            return false;
        }
        Stream<Object> entityStream = entities.stream().filter(this.criteria::evaluate);
        Optional<Object> result = entityStream.findAny();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Query for class {} found an entity: {}", (Object)clazz.getSimpleName(), (Object)result.isPresent());
        }
        return result.isPresent();
    }
}

