/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query.executors;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Stream;
import org.springframework.data.domain.Sort;
import software.xdev.spring.data.eclipse.store.exceptions.NotComparableException;
import software.xdev.spring.data.eclipse.store.repository.access.AccessHelper;
import software.xdev.spring.data.eclipse.store.util.GenericObjectComparer;

public final class EntitySorter {
    private EntitySorter() {
    }

    public static <T> Stream<T> sortEntitiesStream(Class<T> clazz, Sort sort, Stream<T> entityStream) {
        Iterator iterator;
        if (sort != null && (iterator = sort.iterator()).hasNext()) {
            Sort.Order order = (Sort.Order)iterator.next();
            try {
                Field fieldForOrder = AccessHelper.getInheritedPrivateField(clazz, order.getProperty());
                Comparator<T> comparator = EntitySorter.getComparator(fieldForOrder, order.getDirection());
                return entityStream.sorted(comparator);
            }
            catch (NoSuchFieldException e) {
                throw new NotComparableException("Could not sort entities by property " + order.getProperty(), e);
            }
        }
        return entityStream;
    }

    private static <T> Comparator<? super T> getComparator(Field fieldForOrder, Sort.Direction direction) {
        return (e1, e2) -> {
            int result = GenericObjectComparer.compare(AccessHelper.readFieldVariable(fieldForOrder, e1), AccessHelper.readFieldVariable(fieldForOrder, e2));
            if (direction.isDescending()) {
                return result * -1;
            }
            return result;
        };
    }
}

