/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query.criteria;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import software.xdev.spring.data.eclipse.store.repository.access.AccessHelper;
import software.xdev.spring.data.eclipse.store.repository.query.ReflectedField;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;

public class CriteriaByExample<T, S extends T>
implements Criteria<T> {
    private final Predicate<T> predicate;

    public CriteriaByExample(Example<S> example) {
        this.predicate = example.getMatcher().isAllMatching() ? entity -> this.getDefinedOrDefaultSpecifiers(example).stream().allMatch(this.createPredicateForSpecifier(example, entity)) : entity -> this.getDefinedOrDefaultSpecifiers(example).stream().anyMatch(this.createPredicateForSpecifier(example, entity));
    }

    private Collection<ExampleMatcher.PropertySpecifier> getDefinedOrDefaultSpecifiers(Example<S> example) {
        Collection specifiers = example.getMatcher().getPropertySpecifiers().getSpecifiers();
        if (!specifiers.isEmpty()) {
            return specifiers;
        }
        ExampleMatcher matcher = ExampleMatcher.matching();
        Map<String, Field> allFields = AccessHelper.getInheritedPrivateFieldsByName(example.getProbeType());
        for (String fieldName : allFields.keySet()) {
            matcher = matcher.withMatcher(fieldName, ExampleMatcher.GenericPropertyMatchers.exact());
        }
        return matcher.getPropertySpecifiers().getSpecifiers();
    }

    @Override
    public boolean evaluate(T object) {
        return this.predicate.test(object);
    }

    private <T> Predicate<ExampleMatcher.PropertySpecifier> createPredicateForSpecifier(Example<S> example, T entity) {
        return specifier -> {
            ReflectedField reflectedField = ReflectedField.createReflectedField(example.getProbeType(), specifier.getPath());
            Object exampleValue = reflectedField.readValue(example.getProbe());
            Optional transformedExampledValue = (Optional)specifier.getPropertyValueTransformer().apply(Optional.ofNullable(exampleValue));
            if (transformedExampledValue.isEmpty()) {
                return true;
            }
            Object value = reflectedField.readValue(entity);
            Optional transformedValue = (Optional)specifier.getPropertyValueTransformer().apply(Optional.ofNullable(value));
            ExampleMatcher.StringMatcher setOrDefaultMatcher = specifier.getStringMatcher() == null ? example.getMatcher().getDefaultStringMatcher() : specifier.getStringMatcher();
            return this.createPredicateForStringMatcher((ExampleMatcher.PropertySpecifier)specifier, setOrDefaultMatcher, transformedExampledValue.get(), transformedValue.orElse(null));
        };
    }

    private boolean createPredicateForStringMatcher(ExampleMatcher.PropertySpecifier specifier, ExampleMatcher.StringMatcher setOrDefaultMatcher, Object transformedExampledValue, Object transformedValue) {
        if (ExampleMatcher.StringMatcher.DEFAULT.equals((Object)setOrDefaultMatcher) || ExampleMatcher.StringMatcher.EXACT.equals((Object)setOrDefaultMatcher)) {
            if (transformedExampledValue instanceof String) {
                return Objects.equals(this.valueToString(transformedExampledValue, specifier), this.valueToString(transformedValue, specifier));
            }
            return Objects.equals(transformedExampledValue, transformedValue);
        }
        BiPredicate<String, String> compareFunc = switch (setOrDefaultMatcher) {
            case ExampleMatcher.StringMatcher.STARTING -> String::startsWith;
            case ExampleMatcher.StringMatcher.ENDING -> String::endsWith;
            case ExampleMatcher.StringMatcher.CONTAINING -> String::contains;
            case ExampleMatcher.StringMatcher.REGEX -> (v, example) -> Pattern.compile(example).matcher((CharSequence)v).find();
            default -> null;
        };
        return compareFunc != null && Optional.ofNullable(this.valueToString(transformedValue, specifier)).map(v -> compareFunc.test((String)v, this.valueToString(transformedExampledValue, specifier))).orElse(false) != false;
    }

    private String valueToString(Object value, ExampleMatcher.PropertySpecifier specifier) {
        if (value == null) {
            return null;
        }
        return specifier != null && Boolean.TRUE.equals(specifier.getIgnoreCase()) ? value.toString().toLowerCase(Locale.ROOT) : value.toString();
    }
}

