/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query.by.example;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.FluentQuery;
import software.xdev.spring.data.eclipse.store.repository.EclipseStoreStorage;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.CriteriaByExample;
import software.xdev.spring.data.eclipse.store.repository.query.executors.CountQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.ExistsQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.ListQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.PageableQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.SingleQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;

public class EclipseStoreFetchableFluentQuery<T, S extends T>
implements FluentQuery.FetchableFluentQuery<S> {
    private final WorkingCopier<T> copier;
    private final Example<S> example;
    private final Class<T> domainClass;
    private final EclipseStoreStorage storage;
    private final Sort sort;

    public EclipseStoreFetchableFluentQuery(WorkingCopier<T> copier, Example<S> example, Class<T> domainClass, EclipseStoreStorage storage, Sort sort) {
        this.copier = copier;
        this.example = example;
        this.domainClass = domainClass;
        this.storage = storage;
        this.sort = sort;
    }

    public FluentQuery.FetchableFluentQuery<S> sortBy(Sort sort) {
        return new EclipseStoreFetchableFluentQuery<T, S>(this.copier, this.example, this.domainClass, this.storage, sort);
    }

    public <R> FluentQuery.FetchableFluentQuery<R> as(Class<R> resultType) {
        throw new UnsupportedOperationException("The method as() is not yet supported");
    }

    public FluentQuery.FetchableFluentQuery<S> project(Collection<String> properties) {
        throw new UnsupportedOperationException("The method project() is not yet supported");
    }

    public S oneValue() {
        return this.firstValue();
    }

    public S firstValue() {
        SingleQueryExecutor<T> query = new SingleQueryExecutor<T>(this.copier, new CriteriaByExample(this.example), this.sort);
        return (S)this.storage.getReadWriteLock().read(() -> query.execute(this.domainClass, this.storage.getEntityList(this.domainClass), new Object[]{this.sort}));
    }

    public List<S> all() {
        ListQueryExecutor<T> query = new ListQueryExecutor<T>(this.copier, new CriteriaByExample(this.example));
        return this.storage.getReadWriteLock().read(() -> query.execute((Class)this.domainClass, this.storage.getEntityList(this.domainClass), new Object[]{this.sort}));
    }

    public Page<S> page(Pageable pageable) {
        PageableQueryExecutor<T> pageableQuery = new PageableQueryExecutor<T>(this.copier, new CriteriaByExample(this.example), this.sort);
        return this.storage.getReadWriteLock().read(() -> pageableQuery.execute(this.domainClass, this.storage.getEntityList(this.domainClass), new Object[]{pageable, this.sort}));
    }

    public Stream<S> stream() {
        return this.all().stream();
    }

    public long count() {
        CountQueryExecutor query = new CountQueryExecutor(new CriteriaByExample(this.example));
        return this.storage.getReadWriteLock().read(() -> query.execute((Class)this.domainClass, this.storage.getEntityList(this.domainClass), (Object[])null));
    }

    public boolean exists() {
        ExistsQueryExecutor query = new ExistsQueryExecutor(new CriteriaByExample(this.example));
        return this.storage.getReadWriteLock().read(() -> query.execute((Class)this.domainClass, this.storage.getEntityList(this.domainClass), (Object[])null));
    }
}

